% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkTVP.R
\name{updateTVP}
\alias{updateTVP}
\title{One step update version of \code{\link{shrinkTVP}} with minimal overhead}
\usage{
updateTVP(
  y,
  x,
  curr_draws,
  mod_type = "double",
  learn_a_xi = TRUE,
  learn_a_tau = TRUE,
  a_xi = 0.1,
  a_tau = 0.1,
  learn_c_xi = TRUE,
  learn_c_tau = TRUE,
  c_xi = 0.1,
  c_tau = 0.1,
  a_eq_c_xi = FALSE,
  a_eq_c_tau = FALSE,
  learn_kappa2_B = TRUE,
  learn_lambda2_B = TRUE,
  kappa2_B = 20,
  lambda2_B = 20,
  hyperprior_param,
  sv = FALSE,
  sv_param,
  MH_tuning
)
}
\arguments{
\item{y}{vector of length N containing the response variable.}

\item{x}{matrix of dimension Nxd containing the covariates.}

\item{curr_draws}{named list containing all the current draws from the joint posterior of the parameters.
Not all values are required for all model setups. The following elements can be supplied:
\itemize{
\item \code{beta_mean_st}: vector of length \code{d} containing single numbers.
\item \code{theta_sr_st}: vector of length \code{d} containing single, positive numbers.
\item \code{tau2_st}: \emph{optional} vector of length \code{d} containing single, positive numbers. Not required if \code{mod_type} is \code{"ridge"}.
\item \code{xi2_st}: \emph{optional} vector of length \code{d} containing single, positive numbers. Not required if \code{mod_type} is \code{"ridge"}.
\item \code{kappa2_st}: \emph{optional} vector of length \code{d} containing single, positive numbers. Only required if \code{mod_type} is \code{"triple"}.
\item \code{lambda2_st}: \emph{optional} vector of length \code{d} containing single, positive numbers. Only required if \code{mod_type} is \code{"triple"}.
\item \code{kappa2_B_st}: \emph{optional} positive, real number. Not required if \code{mod_type} is \code{"ridge"} or \code{learn_kappa2_B} is \code{FALSE}.
\item \code{lambda2_B_st}: \emph{optional} positive, real number. Not required if \code{mod_type} is \code{"ridge"} or \code{learn_lambda2_B} is \code{FALSE}.
\item \code{a_xi_st}: \emph{optional} positive, real number. Not required if \code{mod_type} is \code{"ridge"} or \code{learn_a_xi} is \code{FALSE}.
\item \code{a_tau_st}: \emph{optional} positive, real number. Not required if \code{mod_type} is \code{"ridge"} or \code{learn_a_tau} is \code{FALSE}.
\item \code{c_xi_st}: \emph{optional} positive, real number. Note that the prior for \code{c_xi} is restricted to (0, 0.5).
Not required if \code{mod_type} is not \code{"triple"} or \code{learn_c_xi} is \code{FALSE}.
\item \code{c_tau_st}: \emph{optional} positive, real number.  Note that the prior for \code{c_tau} is restricted to (0, 0.5).
Not required if \code{mod_type} is not \code{"triple"} or \code{learn_c_tau} is \code{FALSE}.
\item \code{sv_mu_st}: \emph{optional} real number. Not required if \code{sv} is \code{FALSE}.
\item \code{sv_phi_st}: \emph{optional} positive, real number between -1 and 1. Not required if \code{sv} is \code{FALSE}.
\item \code{sv_sigma2_st }: \emph{optional} positive, real number. Not required if \code{sv} is \code{FALSE}.
\item \code{C0_st}: \emph{optional} positive, real number. Not required if \code{sv} is \code{TRUE}.
\item \code{sigma2_st}: positive, real number if \code{sv} is \code{FALSE}, otherwise a vector of positive, real numbers of length \code{N}. The default value is 1 or a vector thereof.
\item \code{h0_st}: \emph{optional} real number. The default value is 0. Not required if \code{sv} is \code{FALSE}.
}}

\item{mod_type}{character string that reads either \code{"triple"}, \code{"double"} or \code{"ridge"}.
Determines whether the triple gamma, double gamma or ridge prior are used for \code{theta_sr} and \code{beta_mean}.
The default is "double".}

\item{learn_a_xi}{logical value indicating whether to learn a_xi, the spike parameter of the state variances.
Ignored if \code{mod_type} is set to \code{"ridge"}. The default value is \code{TRUE}.}

\item{learn_a_tau}{logical value indicating whether to learn a_tau, the spike parameter of the mean of the
initial values of the states. Ignored if \code{mod_type} is set to \code{"ridge"}. The default value is \code{TRUE}.}

\item{a_xi}{positive, real number, indicating the (fixed) value for a_xi. Ignored if
\code{learn_a_xi} is \code{TRUE} or \code{mod_type} is set to \code{"ridge"}. The default value is 0.1.}

\item{a_tau}{positive, real number, indicating the (fixed) value for a_tau. Ignored if
\code{learn_a_tau} is \code{TRUE} or \code{mod_type} is set to \code{"ridge"}. The default value is 0.1.}

\item{learn_c_xi}{logical value indicating whether to learn c_xi, the tail parameter of the state variances.
Ignored if \code{mod_type} is not set to \code{"triple"}. The default value is \code{TRUE}.}

\item{learn_c_tau}{logical value indicating whether to learn c_tau, the tail parameter of the mean of the
initial values of the states. Ignored if \code{mod_type} is not set to \code{"triple"}. The default value is \code{TRUE}.}

\item{c_xi}{positive, real number, indicating the (fixed) value for c_xi. Ignored if
\code{learn_c_xi} is \code{TRUE} or \code{mod_type} is not set to \code{"triple"}. The default value is 0.1.}

\item{c_tau}{positive, real number, indicating the (fixed) value for c_tau. Ignored if
\code{learn_c_xi} is \code{TRUE} or \code{mod_type} is not set to \code{"triple"}. The default value is 0.1.}

\item{a_eq_c_xi}{logical value indicating whether to force \code{a_xi} and \code{c_xi} to be equal.
Ignored if \code{mod_type} is not set to \code{"triple"}. The default value is \code{FALSE}.}

\item{a_eq_c_tau}{logical value indicating whether to force \code{a_tau} and \code{c_tau} to be equal.
Ignored if \code{mod_type} is not set to \code{"triple"}. The default value is \code{FALSE}.}

\item{learn_kappa2_B}{logical value indicating whether to learn kappa2_B, the global level of shrinkage for
the state variances. The default value is \code{TRUE}.}

\item{learn_lambda2_B}{logical value indicating whether to learn the lambda2_B parameter,
the global level of shrinkage for the mean of the initial values of the states. The default value is \code{TRUE}.}

\item{kappa2_B}{positive, real number, indicating the (fixed) value for kappa2_B. Ignored if
\code{learn_kappa2_B} is \code{TRUE}. The default value is 20.}

\item{lambda2_B}{positive, real number, indicating the (fixed) value for lambda2_B. Ignored if
\code{learn_lambda2_B} is \code{TRUE}. The default value is 20.}

\item{hyperprior_param}{\emph{optional} named list containing hyperparameter values.
Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown.
All hyperparameter values have to be positive, real numbers. The following hyperparameters can be
supplied:
\itemize{
\item \code{c0}: The default value is 2.5.
\item \code{g0}: The default value is 5.
\item \code{G0}: The default value is 5 / (2.5 - 1).
\item \code{e1}: The default value is 0.001.
\item \code{e2}: The default value is 0.001.
\item \code{d1}: The default value is 0.001.
\item \code{d2}: The default value is 0.001.
\item \code{beta_a_xi}: The default value is 10.
\item \code{beta_a_tau}: The default value is 10.
\item \code{alpha_a_xi}: The default value is 5.
\item \code{alpha_a_tau}: The default value is 5.
\item \code{beta_c_xi}: The default value is 2.
\item \code{alpha_c_xi}: The defalut value is 5.
\item \code{beta_c_tau}: The default value is 2.
\item \code{alpha_c_tau}: The defalut value is 5.
}}

\item{sv}{logical value indicating whether to use stochastic volatility for the error of the observation
equation. For details please see \code{\link{stochvol}}, in particular \code{\link{svsample}}. The default value is
\code{FALSE}.}

\item{sv_param}{\emph{optional} named list containing hyperparameter values for the stochastic volatility
parameters. Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown. Ignored if
\code{sv} is \code{FALSE}. The following elements can be supplied:
\itemize{
\item \code{Bsigma_sv}: positive, real number. The default value is 1.
\item \code{a0_sv}: positive, real number. The default value is 5.
\item \code{b0_sv}: positive, real number. The default value is 1.5.
\item \code{bmu}: real number. The default value is 0.
\item \code{Bmu}: real number. larger than 0. The default value is 1.
}}

\item{MH_tuning}{\emph{optional} named list containing values used to tune the MH steps for \code{a_xi}, \code{a_tau},
\code{c_xi} and \code{c_tau}. Not all have to be supplied, with those missing being replaced by the default values.
Any list elements that are misnamed will be ignored and a warning will be thrown.
The arguments for \code{a_xi}(\code{a_tau}) are only used if \code{learn_a_xi}(\code{learn_a_tau})
is set to \code{TRUE} and \code{mod_type} is not equal to \code{"ridge"}. The arguments for \code{c_xi}(\code{c_tau}) are only
used if \code{learn_c_xi}(\code{learn_c_tau}) is set to \code{TRUE} and \code{mod_type} is equal to \code{"triple"}. Arguments ending in "adaptive" are
logical values indicating whether or not to make the MH step for the respective parameter adaptive. Arguments ending in "tuning_par" serve two different purposes.
If the respective MH step is not set to be adaptive, it acts as the standard deviation of the proposal distribution. If the respective MH step
is set to be adaptive, it acts as the initial standard deviation. Arguments ending in "target_rate" define the acceptance rate the algorithm aims to achieve.
Arguments ending in "max_adapt" set the maximum value by which the logarithm of the standard deviation of the proposal distribution is adjusted. Finally,
arguments ending in "batch_size" set the batch size after which the standard deviation of the proposal distribution is adjusted.
The following elements can be supplied:
\itemize{
\item \code{a_xi_adaptive}: logical value. The default is \code{TRUE}.
\item \code{a_xi_tuning_par}: positive, real number. The default value is 1.
\item \code{a_xi_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{a_xi_max_adapt}: positive, real number. The default value is 0.01.
\item \code{a_xi_batch_size}: positive integer. The default value is 50.
\item \code{a_tau_adaptive}: logical value. The default is \code{TRUE}.
\item \code{a_tau_tuning_par}: positive, real number. The default value is 1.
\item \code{a_tau_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{a_tau_max_adapt}: positive, real number. The default value is 0.01.
\item \code{a_tau_batch_size}: positive integer. The default value is 50.
\item \code{c_xi_adaptive}: logical value. The default is \code{TRUE}.
\item \code{c_xi_tuning_par}: positive, real number. The default value is 1.
\item \code{c_xi_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{c_xi_max_adapt}: positive, real number. The default value is 0.01.
\item \code{c_xi_batch_size}: positive integer. The default value is 50.
\item \code{c_tau_adaptive}: logical value. The default is \code{TRUE}.
\item \code{c_tau_tuning_par}: positive, real number. The default value is 1.
\item \code{c_tau_target_rate}: positive, real number, between 0 and 1. The default value is 0.44.
\item \code{c_tau_max_adapt}: positive, real number. The default value is 0.01.
\item \code{c_tau_batch_size}: positive integer. The default value is 50.
}}
}
\value{
The value returned is a named list object which can be immediately used as the \code{curr_draws} argument
for another draw from the posterior with \code{updateTVP}. Note that, depending on the model setup, some elements may be matrices of dimension zero.
It contains the following elements:
\item{\code{beta_st}}{dx(N + 1) matrix containing the current draw from the posterior distribtuion of beta.}
\item{\code{beta_mean_st}}{dx1 matrix containing the current draws from the posterior distribution of beta_mean.}
\item{\code{theta_sr_st}}{dx1 matrix containing the current draws from the posterior distribution of the square root of theta.}
\item{\code{tau2_st}}{dx1 matrix containing the current draws from the posterior distribution of tau2.}
\item{\code{xi2_st}}{dx1 matrix containing the current draws from the posterior distribution of xi2.}
\item{\code{lambda2_st}}{dx1 matrix containing the current draws from the posterior distribution of lambda2.}
\item{\code{kappa2_st}}{dx1 matrix containing the current draws from the posterior distribution of kappa2.}
\item{\code{a_xi_st}}{number representing the current draw from the posterior distribution of a_xi.}
\item{\code{a_tau_st}}{number representing the current draw from the posterior distribution of a_tau.}
\item{\code{c_xi_st}}{number representing the current draw from the posterior distribution of c_xi.}
\item{\code{c_tau_st}}{number representing the current draw from the posterior distribution of c_tau.}
\item{\code{lambda2_B_st}}{number representing the current draw from the posterior distribution of lambda2_B.}
\item{\code{kappa2_B_st}}{\code{mcmc} object containing the parameter draws from the posterior distribution of kappa2_B.}
\item{\code{sigma2_st}}{number if \code{sv} is \code{FALSE}, otherwise a vector of length \code{N} containing the current draws from the posterior distribution of sigma2.}
\item{\code{C0_st}}{number representing the current draw from the posterior distribution of C0.}
\item{\code{sv_mu_st}}{number representing the current draw from the posterior distribution of the mu parameter for the stochastic volatility model on the errors.}
\item{\code{sv_phi_st}}{number representing the current draw from the posterior distribution of the phi parameter for the stochastic volatility model on the errors.}
\item{\code{sv_sigma2_st}}{number representing the current draw from the posterior distribution of the sigma2 parameter for the stochastic volatility model on the errors.}
\item{\code{h0_st}}{number representing the current draw from the posterior distribution of the h0 parmater for the stochastic volatility model on the errors.}
\item{\code{internals}}{\code{list} object containg two arrays that are required for calculating the LPDS and bookkeeping objects required for the adaptive MH algorithm to work.}
}
\description{
\code{updateTVP} draws a single sample from the joint posterior distribution of the parameters of a time-varying
parameter model with shrinkage potentially including stochastic volatility (SV). It performs \bold{no input checks} and must
therefore be used with caution. It is designed to be used in a modular fashion within other samplers, where speed is important.
As such, no draws are saved and must be stored manually if the user wants to analyze them further.
}
\examples{
\donttest{
# Simulate data
sim <- simTVP()
y <- sim$data$y
x <- as.matrix(sim$data[,2:4])

# Create starting values
d <- ncol(x)
curr_draws <- list(beta_mean_st = rep(0, d),
                   theta_sr_st = rep(1, d),
                   tau2_st = rep(1, d),
                   xi2_st = rep(1, d),
                   lambda2_st = rep(1, d),
                   kappa2_B_st = 20,
                   lambda2_B_st = 20,
                   a_xi_st = 0.1,
                   a_tau_st = 0.1,
                   c_tau_st = 0.1,
                   sv_mu_st = -10,
                   sv_phi_st = 0.5,
                   sv_sigma2_st = 1,
                   C0_st = 1,
                   sigma2_st = 1,
                   h0_st = 0)

# Run the algorithm for 1000 iterations
# Note that curr_draws is always re-written and immediately re-used
for (i in 1:1000){
  curr_draws <- updateTVP(y, x, curr_draws)
}
}

}
\references{
Bitto, A., & Frühwirth-Schnatter, S. (2019). "Achieving shrinkage in a time-varying parameter model framework."
\emph{Journal of Econometrics}, 210(1), 75-97. <doi:10.1016/j.jeconom.2018.11.006>

Cadonna, A., Frühwirth-Schnatter, S., & Knaus, P. (2020). "Triple the Gamma—A Unifying Shrinkage Prior for Variance and Variable Selection in Sparse State Space and TVP Models."
\emph{Econometrics}, 8(2), 20. <doi:10.3390/econometrics8020020>
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
