% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TInterval.R
\name{TIntervalS}
\alias{TIntervalS}
\title{Student-T tolerance-style interval around an estimate of a mean from summary.}
\usage{
TIntervalS(
  sample_size,
  sample_mean,
  sample_var,
  ...,
  nNA = 0,
  conf.level = 0.95
)
}
\arguments{
\item{sample_size}{numeric scalar integer, size of sample.}

\item{sample_mean}{numeric scalar, mean of sample.}

\item{sample_var}{numeric scalar, variance of sample (Bessel-corrected).}

\item{...}{extra arguments passed to TInterval.}

\item{nNA}{number of NAs seen.}

\item{conf.level}{confidence level to draw interval}
}
\value{
wrapped stat
}
\description{
Student-T tolerance-style interval around an estimate of a mean from summary.
}
\examples{

set.seed(2018)
d <- rnorm(100) + 3.2
TIntervalS(length(d), mean(d), stats::var(d))

}
\seealso{
\code{\link{TInterval}}, \code{\link{TIntervalS}}, \code{\link{TInterval.numeric}}, \code{\link{TInterval.data.frame}}
}
