% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupSkewedGammaParameters.R
\name{calculate_stats_gamma}
\alias{calculate_stats_gamma}
\title{Calculate summary statistics and gamma parameters for each group}
\usage{
calculate_stats_gamma(data_df, group_col, using = c("MoM", "gMLE"))
}
\arguments{
\item{data_df}{A data frame containing the data to be processed.}

\item{group_col}{A character string specifying the name of the column to
group by.}

\item{using}{which method will be used to estimate the multivariate Gamma
shape and rate parameters. Defaults to \code{"MoM"} (method of moments, which was
used in the author's paper), or \code{"gMLE"} (maximum likelihood estimates from
the Generalized Gamma distribution without bias correction).}
}
\value{
A list of lists, where each inner list contains:
\itemize{
\item sample size (n)
\item sample mean vector (mean)
\item gamma distribution parameters (shape, rate)
\item Spearman correlation matrix (cor)
}
}
\description{
This function computes the sample size, gamma distribution
parameters (shape and rate), and Spearman correlation matrix for each group,
based on the grouping column.
}
\examples{
myData <- data.frame(
  GENDER = c('Male', 'Female', 'Male', 'Female', 'Male', 'Female'),
  VALUE1 = c(1.2, 2.3, 1.5, 2.7, 1.35, 2.5),
  VALUE2 = c(3.4, 4.5, 3.8, 4.2, 3.6, 4.35)
)
calculate_stats_gamma(myData, "GENDER")
}
