\name{vgamma}
\alias{vgamma}
\alias{Gamma}

\title{Variate Generator for the Gamma Distribution}
\description{
  Generates random variates from the gamma distribution, with options for
  independent streams and antithetic variates.
}
\usage{
  vgamma(n, shape, rate = 1, scale = 1/rate, stream = NULL, antithetic = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{number of observations}
  \item{shape, scale}{shape and scale parameters (must be positive)}
  \item{rate}{an alternative way to specify the scale}
  \item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
    to generate uniform variates to invert via \code{\link[=qgamma]{stats::qgamma}}; 
    otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
    from which to generate uniform variates to invert via
    \code{\link[=qgamma]{stats::qgamma}}}
  \item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
    variate(s) generated via either \code{\link[=runif]{stats::runif}} or
    \code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
    \eqn{1 - u}}
}
\details{
  Generates random variates from the gamma distribution.

  Gamma variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}} (if
  \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qgamma]{stats::qgamma}} is used to invert the
  uniform(0,1) variate(s).
  In this way, using \code{vgamma} provides a monotone and synchronized
  gamma variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

  If \code{scale} is omitted, it assumes the default value of 1.

  The gamma distribution with parameters \code{shape =} \eqn{a} and 
  \code{scale =} \eqn{s} has density

      \deqn{f(x) = 1/(s^a Gamma(a)) x^(a-1) e^-(x/s)}

   for \eqn{x \ge 0}, \eqn{a > 0}, and \eqn{s > 0}. (Here \eqn{Gamma(a)} is the
   function implemented by R's \code{\link{gamma}()} and defined in its help.)

   The mean and variance are \eqn{E(X) = a*s} and \eqn{Var(X) = a*s^2}.

}
\value{
  A vector of gamma random variates.
}
\seealso{
    \code{\link[=rgamma]{stats::rgamma}}, \code{\link[=runif]{stats::runif}},
    \code{\link{rstream}}, \code{\link{set.seed}}
}
\author{Barry Lawson (\email{blawson@richmond.edu}), 
        Larry Leemis (\email{leemis@math.wm.edu})}
\examples{
set.seed(8675309)
vgamma(3, shape = 2, scale = 1)  # inverts stats::runif using stats::qgamma

set.seed(8675309)
vgamma(3, shape = 2, scale = 1, stream = 1)  # inverts rstream::rstream.sample using stats::qgamma
vgamma(3, shape = 2, scale = 1, stream = 2)

set.seed(8675309)
vgamma(1, shape = 2, scale = 1, stream = 1)  # inverts rstream::rstream.sample using stats::qgamma
vgamma(1, shape = 2, scale = 1, stream = 2)
vgamma(1, shape = 2, scale = 1, stream = 1)
vgamma(1, shape = 2, scale = 1, stream = 2)
vgamma(1, shape = 2, scale = 1, stream = 1)
vgamma(1, shape = 2, scale = 1, stream = 2)

set.seed(8675309)
variates <- vgamma(1000, shape = 2, scale = 1, stream = 1)
set.seed(8675309)
variates <- vgamma(1000, shape = 2, scale = 1, stream = 1, antithetic = TRUE)
}
\keyword{distribution}  % RShowDoc("KEYWORDS") for suggested list
\concept{random variate generation}
