% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITSModelingCode.R
\name{add_lagged_covariates}
\alias{add_lagged_covariates}
\title{Augment dataframe with lagged covariates}
\usage{
add_lagged_covariates(dat, outcomename, covariates = NULL)
}
\arguments{
\item{dat}{The dataframe}

\item{outcomename}{The outcome of interest (string)}

\item{covariates}{The covariates to lag along with the outcome. This can be
either of two things.  First, it can be a list of string names.  Covariates
can also be a function with a "lags" attribute with the listed covariates
(as returned by, e.g., make_fit_season_model)  (which is a list of string
names). NULL if no covariates other than outcome should be lagged.}
}
\value{
Augmented dataframe with lagged covariates as new columns. Will
  clobber old columns if the names (of form "lag.XXXX") conflict.
}
\description{
Take outcome and a list of covariates and add new columns with lagged
versions.  Assumes rows of dataframe are in time ascending order.  Lagged
outcome canonically called 'lag.outcome'.  Covariates 'lag.XXX'.
}
\examples{
data( "newjersey" )
newjersey = add_lagged_covariates(newjersey, "n.warrant", c("sin.m","cos.m" ) )
head( newjersey[ c( "n.warrant", "sin.m", "lag.outcome", "lag.sin.m" ) ] )
}
