% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-sim-ssm-lin-growth-i-vary.R
\name{SimSSMLinGrowthIVary}
\alias{SimSSMLinGrowthIVary}
\title{Simulate Data from a Linear Growth Curve Model
(Individual-Varying Parameters)}
\usage{
SimSSMLinGrowthIVary(
  n,
  mu0,
  sigma0,
  theta,
  gamma_y = NULL,
  gamma_eta = NULL,
  x = NULL,
  type = 0,
  time
)
}
\arguments{
\item{n}{Positive integer.
Number of individuals.}

\item{mu0}{A list of numeric vectors.
Each element of the list
is a vector of length two.
The first element is the mean of the intercept,
and the second element is the mean of the slope.}

\item{sigma0}{A list of numeric matrices.
Each element of the list
is the covariance matrix
of the intercept and the slope.}

\item{theta}{A list numeric values.
Each element of the list
is the common measurement error variance.}

\item{gamma_y}{Numeric matrix.
Matrix relating the values of the covariate matrix
at time \code{t} to \code{y} at time \code{t}
(\eqn{\boldsymbol{\Gamma}_{\mathbf{y}}}).}

\item{gamma_eta}{Numeric matrix.
Matrix relating the values of the covariate matrix
at time \code{t} to the latent variables (intercept and slope) at time \code{t}
(\eqn{\boldsymbol{\Gamma}_{\boldsymbol{\eta}}}).}

\item{x}{A list of length \code{n} of numeric matrices.
Each element of the list
is a matrix of observed covariates in \code{type = 1} or \code{type = 2}.
The number of rows in each matrix should be equal to \code{time}.}

\item{type}{Integer.
State space model type.
See Details for more information.}

\item{time}{Positive integer.
Number of time points to simulate.}
}
\value{
Returns an object of class \code{simstatespace}
which is a list with the following elements:
\itemize{
\item \code{call}: Function call.
\item \code{args}: Function arguments.
\item \code{data}: Generated data which is a list of length \code{n}.
Each element of \code{data} is a list with the following elements:
\itemize{
\item \code{id}: A vector of ID numbers of length \code{t}.
\item \code{time}: A vector time points of length \code{t}.
\item \code{y}: A \code{t} by \code{k} matrix of values for the manifest variables.
\item \code{eta}: A \code{t} by \code{p} matrix of values for the latent variables.
\item \code{x}: A \code{t} by \code{j} matrix of values for the covariates.
}
\item \code{fun}: Function used.
}
}
\description{
This function simulates data
from a linear growth curve model
for \code{n > 1} individuals.
In this model,
the parameters can vary across individuals.
}
\details{
Parameters can vary across individuals
by providing a list of parameter values.
If the length of any of the parameters
(\code{mu0},
\code{sigma0},
\code{mu},
\code{theta},
\code{gamma_y}, or
\code{gamma_eta})
is less the \code{n},
the function will cycle through the available values.
}
\examples{
# prepare parameters
# In this example, the mean vector of the intercept and slope vary.
# Specifically,
# there are two sets of values representing two latent classes.
set.seed(42)
n <- 10
mu0_1 <- c(0.615, 1.006) # lower starting point, higher growth
mu0_2 <- c(1.000, 0.500) # higher starting point, lower growth
mu0 <- list(mu0_1, mu0_2)
sigma0 <- list(
  matrix(
    data = c(
      1.932,
      0.618,
      0.618,
      0.587
    ),
    nrow = 2
  )
)
theta <- list(0.6)
time <- 10
gamma_y <- list(matrix(data = 0.10, nrow = 1, ncol = 2))
gamma_eta <- list(matrix(data = 0.10, nrow = 2, ncol = 2))
x <- lapply(
  X = seq_len(n),
  FUN = function(i) {
    return(
      matrix(
        data = rnorm(n = 2 * time),
        ncol = 2
      )
    )
  }
)

# Type 0
ssm <- SimSSMLinGrowthIVary(
  n = n,
  mu0 = mu0,
  sigma0 = sigma0,
  theta = theta,
  type = 0,
  time = time
)

plot(ssm)

# Type 1
ssm <- SimSSMLinGrowthIVary(
  n = n,
  mu0 = mu0,
  sigma0 = sigma0,
  theta = theta,
  gamma_eta = gamma_eta,
  x = x,
  type = 1,
  time = time
)

plot(ssm)

# Type 2
ssm <- SimSSMLinGrowthIVary(
  n = n,
  mu0 = mu0,
  sigma0 = sigma0,
  theta = theta,
  gamma_y = gamma_y,
  gamma_eta = gamma_eta,
  x = x,
  type = 2,
  time = time
)

plot(ssm)

}
\references{
Chow, S.-M., Ho, M. R., Hamaker, E. L., & Dolan, C. V. (2010).
Equivalence and differences between structural equation modeling
and state-space modeling techniques.
\emph{Structural Equation Modeling: A Multidisciplinary Journal},
17(2), 303–332.
\doi{10.1080/10705511003661553}
}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{OU2SSM}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMOU}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SimSSMVAR}()},
\code{\link{SimSSM}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{growth}
\keyword{sim}
\keyword{simStateSpace}
