% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptionsManager.R
\name{OptionsManager}
\alias{OptionsManager}
\title{OptionsManager}
\usage{
OptionsManager(options_path, default_options = list(), permissions = "600",
  auto_save = TRUE, strict = FALSE, verbose = FALSE)
}
\arguments{
\item{options_path}{the path to the option file. For script I recommend to use something like "./option_file.json",
for R packages something like "~/.package_name/option_file.json"}

\item{default_options}{this should be a list containing the default values to use when creating an options file.}

\item{permissions}{a string containing the permissions to apply to the file. It defaults to "600"}

\item{auto_save}{whether to save automatically the option file when you change an option value. It defaults to TRUE}

\item{strict}{whether only option names appearing in "default_options" should be accepted or not. It defaults to FALSE,
but I recommend to set it to TRUE if you are using simpleroptions in a package.}

\item{verbose}{whether to show some information messages or not. It defaults to FALSE.}
}
\value{
an "OptionsManager" R6 object
}
\description{
Create an OptionsManager object, to easily manage an option file to be used in your functions
and scripts.
}
\examples{

exOpt <- OptionsManager(
  options_path = "./example_options.json",
  default_options = list(
    image_directory = ".",
    image_extension = ".jpg"
    )
)

# You can modify the values in the options file using the `set()` method
exOpt$set(image_directory = "images",
          image_extension = ".png")
          
}
