% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMultiFac.R
\name{addMultiFac}
\alias{addMultiFac}
\title{Add multi-factorial data}
\usage{
addMultiFac(dtOld, nFactors, levels = 2, coding = "dummy",
  colNames = NULL)
}
\arguments{
\item{dtOld}{data.table that is to be modified}

\item{nFactors}{Number of factors (columns) to generate.}

\item{levels}{Vector or scalar. If a vector is specified, it must be
the same length as nFatctors. Each value of the vector represents the
number of levels of each corresponding factor. If a scalar is specified,
each factor will have the same number of levels. The default is 2 levels
for each factor.}

\item{coding}{String value to specify if "dummy" or "effect" coding is used.
Defaults to "dummy".}

\item{colNames}{A vector of strings, with a length of nFactors. The strings
represent the name for each factor.}
}
\value{
A data.table that contains the added simulated data. Each new column contains
an integer.
}
\description{
Add multi-factorial data
}
\examples{
defD <-defData(varname = "x", formula = 0, variance = 1)

DT <- genData(360, defD)
DT <- addMultiFac(DT, nFactors = 3, levels = c(2, 3, 3), colNames = c("A", "B", "C"))
DT
DT[, .N, keyby = .(A, B, C)]

DT <- genData(300, defD)
DT <- addMultiFac(DT, nFactors = 3, levels = 2)
DT[, .N, keyby = .(Var1, Var2, Var3)]

}
