% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_sin}
\alias{gen_sin}
\title{Generate a Sinusoidal Process given \eqn{\alpha^2} and \eqn{\beta}.}
\usage{
gen_sin(N, alpha2 = 9e-04, beta = 0.06, U = 1)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{alpha2}{A \code{double} that contains the squared amplitude parameter alpha2.}

\item{beta}{A \code{double} that contains the angular frequency parameter beta.}
}
\value{
sn A \code{vec} containing the sinusoidal process.
}
\description{
Simulates a Sinusoidal Process Process with parameter \eqn{\alpha^2} and \eqn{\beta}
}
\section{Generation Algorithm}{

The function first generates a initial cycle oscillation at t=0 from a Uniform law with parameter a = 0 and b = 2 * pi 
and then compute the signal from its definition \deqn{X_t = \alpha \sin(\beta t + U)}.
}

\keyword{internal}
