% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkers.R
\name{.check_sim_input}
\alias{.check_sim_input}
\title{Check if arguments input to simulation function are valid}
\usage{
.check_sim_input(
  sim_type = c("linelist", "contacts", "outbreak"),
  contact_distribution,
  infectious_period,
  prob_infection,
  outbreak_start_date,
  outbreak_size,
  onset_to_hosp = NULL,
  onset_to_death = NULL,
  onset_to_recovery = NULL,
  anonymise = NULL,
  case_type_probs = NULL,
  contact_tracing_status_probs = NULL,
  hosp_risk = NULL,
  hosp_death_risk = NULL,
  non_hosp_death_risk = NULL,
  population_age = NULL
)
}
\arguments{
\item{sim_type}{A \code{character} string specifying which simulation function
this function is being called within.}

\item{contact_distribution}{A \code{function} or an \verb{<epiparameter>} object to
generate the number of contacts per infection.

The function can be defined or anonymous. The function must have a single
argument in the form of an \code{integer} vector with elements representing the
number of contacts, and return a \code{numeric} vector where each element
corresponds to the probability of observing the number of contacts in the
vector passed to the function. The index of the \code{numeric} vector returned
is offset by one to the corresponding probability of observing the number
of contacts, i.e. the first element of the output vector is the probability
of observing zero contacts, the second element is the probability of
observing one contact, etc.

An \verb{<epiparameter>} can be provided. This will be converted into a
probability mass function internally.

The default is an anonymous function with a Poisson probability mass function
(\code{\link[=dpois]{dpois()}}) with a mean (\eqn{\lambda}) of 2 contacts per infection.}

\item{infectious_period}{A \code{function} or an \verb{<epiparameter>} object for the
infectious period. This defines the duration from becoming infectious to
no longer infectious. In the simulation, individuals are assumed to
become infectious immediately after being infected (the latency period is
assumed to be zero). The time intervals between an infected individual and
their contacts are assumed to be uniformly distributed within the
infectious period. Infectious periods must be strictly positive.

The function can be defined or anonymous. The function must return a vector
of randomly generated real numbers representing sampled infectious periods.
The function must have a single argument, the number of random infectious
periods to generate.

An \verb{<epiparameter>} can be provided. This will be converted into random
number generator internally.

The default is an anonymous function with a lognormal distribution random
number generator (\code{\link[=rlnorm]{rlnorm()}}) with \code{meanlog = 2} and \code{sdlog = 0.5}.}

\item{prob_infection}{A single \code{numeric} for the probability of a secondary
contact being infected by an infected primary contact.}

\item{outbreak_start_date}{A \code{date} for the start of the outbreak.}

\item{outbreak_size}{A \code{numeric} vector of length 2 defining the minimum and
the maximum number of infected individuals for the simulated outbreak.
Default is \code{c(10, 1e4)}, so the minimum outbreak size is 10 infected
individuals, and the maximum outbreak size is 10,000 infected individuals.
Either number can be changed to increase or decrease the maximum or minimum
outbreak size to allow simulating larger or smaller outbreaks. If the
minimum outbreak size cannot be reached after running the simulation for
many iterations (internally) then the function errors, whereas if the
maximum outbreak size is exceeded the function returns the data early and a
warning stating how many cases and contacts are returned.}

\item{onset_to_hosp}{A \code{function} or an \verb{<epiparameter>} object for the
onset-to-hospitalisation delay distribution. \code{onset_to_hosp} can also be
set to \code{NULL} to not simulate hospitalisation (admission) dates.

The function can be defined or anonymous. The function must return a vector
of \code{numeric}s for the length of the onset-to-hospitalisation delay. The
function must have a single argument.

An \verb{<epiparameter>} can be provided. This will be converted into a random
number generator internally.

The default is an anonymous function with a lognormal distribution random
number generator (\code{\link[=rlnorm]{rlnorm()}}) with \code{meanlog = 1.5} and \code{sdlog = 0.5}.

If \code{onset_to_hosp} is set to \code{NULL} then \code{hosp_risk} and \code{hosp_death_risk}
will be automatically set to \code{NULL} if not manually specified.}

\item{onset_to_death}{A \code{function} or an \verb{<epiparameter>} object for the
onset-to-death delay distribution. \code{onset_to_death} can also be set to
\code{NULL} to not simulate dates for individuals that died.

The function can be defined or anonymous. The function must return a vector
of \code{numeric}s for the length of the onset-to-death delay. The function must
have a single argument.

An \verb{<epiparameter>} can be provided. This will be converted into a random
number generator internally.

The default is an anonymous function with a lognormal distribution random
number generator (\code{\link[=rlnorm]{rlnorm()}}) with \code{meanlog = 2.5} and \code{sdlog = 0.5}.

If \code{onset_to_death} is set to \code{NULL} then \code{non_hosp_death_risk} and
\code{hosp_death_risk} will be automatically set to \code{NULL} if not manually
specified.}

\item{onset_to_recovery}{A \code{function} or an \verb{<epiparameter>} object for the
onset-to-recovery delay distribution. \code{onset_to_recovery} can also be \code{NULL}
to not simulate dates for individuals that recovered.

The function can be defined or anonymous. The function must return a vector
of \code{numeric}s for the length of the onset-to-recovery delay. The function
must have a single argument.

An \verb{<epiparameter>} can be provided. This will be converted into a random
number generator internally.

The default is \code{NULL} so by default cases that recover get an \code{NA} in the
\verb{$date_outcome} line list column.}

\item{anonymise}{A \code{logical} boolean for whether case names should be
anonymised. Default is \code{FALSE}.}

\item{case_type_probs}{A named \code{numeric} vector with the probability of
each case type. The names of the vector must be \code{"suspected"}, \code{"probable"},
\code{"confirmed"}. Values of each case type must sum to one.}

\item{contact_tracing_status_probs}{A named \code{numeric} vector with the
probability of each contact tracing status. The names of the vector must
be \code{"under_followup"}, \code{"lost_to_followup"}, \code{"unknown"}. Values of each
contact tracing status must sum to one.}

\item{hosp_risk}{Either a single \code{numeric} for the hospitalisation risk of
everyone in the population, or a \verb{<data.frame>} with age specific
hospitalisation risks. Default is 20\% hospitalisation (\code{0.2}) for the entire
population. If the \code{onset_to_hosp} argument is set to \code{NULL} this argument
will automatically be set to \code{NULL} if not specified or can be manually
set to \code{NULL}. See details and examples for more information.}

\item{hosp_death_risk}{Either a single \code{numeric} for the death risk for
hospitalised individuals across the population, or a \verb{<data.frame>} with age
specific hospitalised death risks Default is 50\% death risk in hospitals
(\code{0.5}) for the entire population. If the \code{onset_to_death} argument is set
to \code{NULL} this argument will automatically be set to \code{NULL} if not specified
or can be manually set to \code{NULL}. See details and examples for more
information. The \code{hosp_death_risk} can vary through time if specified in
the \code{time_varying_death_risk} element of \code{config}, see
\code{vignette("time-varying-cfr", package = "simulist")} for more information.}

\item{non_hosp_death_risk}{Either a single \code{numeric} for the death risk for
outside of hospitals across the population, or a \verb{<data.frame>} with age
specific death risks outside of hospitals. Default is 5\% death risk outside
of hospitals  (\code{0.05}) for the entire population. If the \code{onset_to_death}
argument is set to \code{NULL} this argument will automatically be set to \code{NULL}
if not specified or can be manually set to \code{NULL}. See details and examples
for more information. The \code{non_hosp_death_risk} can vary through time if
specified in the \code{time_varying_death_risk} element of \code{config}, see
\code{vignette("time-varying-cfr", package = "simulist")} for more information.}

\item{population_age}{Either a \code{numeric} vector with two elements or a
\verb{<data.frame>} with age structure in the population. Use a \code{numeric} vector
to specific the age range of the population, the first element is the lower
bound for the age range, and and the second is the upper bound for the age
range (both inclusive, i.e. [lower, upper]). The \verb{<data.frame>} with
age groups and the proportion of the population in that group. See details
and examples for more information.}
}
\value{
Invisibly return the \code{sim_type} \code{character} string. The function is
called for its side-effects, which will error if the input is invalid.
}
\description{
Check if arguments input to simulation function are valid
}
\details{
Arguments that are used by all simulation functions are required
and not given a default value, for other arguments that are not inputs in
all simulation functions a default of \code{NULL} is used.

Defaults mentioned in argument documentation is the default for the exported
simulation function and not the default in this checking function. In this
function there is either no default or \code{NULL}.
}
\keyword{internal}
