% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_silico_population.R
\name{plotMutations}
\alias{plotMutations}
\title{Plots the QTL effect coefficients of a population.}
\usage{
plotMutations(insilicopopulation, insilicosystem, scaleLims = NULL,
  qtlEffectCoeffs = insilicopopulation$indargs$qtlnames,
  inds = names(insilicopopulation$individualsList),
  alleles = insilicopopulation$indargs$gcnList,
  genes = 1:length(insilicopopulation$GenesVariants),
  nGenesPerRow = 10, ...)
}
\arguments{
\item{insilicopopulation}{The in silico population to be simulated (see \code{\link{createInSilicoPopulation}}).}

\item{insilicosystem}{The in silico system (object of class \code{insilicosystem}, see \code{\link{createInSilicoSystem}}).}

\item{scaleLims}{A vector of length 2 giving the lower and upper limits of the continuous scale (of the QTL effect coefficient
values) to be plotted. QTL effect coefficients with values outside these limits are plotted as NA (gray). If NULL (default), the limits are
automatically set to the min and max values in the dataset.}

\item{qtlEffectCoeffs}{A character vector of QTL effect coefficient names to plot. By default, all QTL effect coefficients are
represented.}

\item{inds}{A character vector giving the names of the individuals to plot. By default, all individuals in the population
are represented.}

\item{alleles}{A character vector giving the names of the alleles to plot. By default, all the alleles are represented.}

\item{genes}{A character or numeric vector of gene IDs to plot. By default, all the genes in the system are represented.}

\item{nGenesPerRow}{Integer. Number of genes to plot per row.}

\item{...}{Any additional parameter to be passed to \code{\link[ggplot2]{theme}} for the plot.}
}
\value{
A plot representing the value (colour) of each QTL effect coefficient (x-axis) of each allele (y-axis) of the different
individuals (rows) for each gene (column) in the system. For noncoding genes, some QTL effect coefficients are not relevant (the ones
related to protein or translation) and are represented in gray as NA.
}
\description{
Plots the QTL effect coefficients for all the genes of a in silico system of the in silico individuals.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 10)
mypop = createInSilicoPopulation(10, mysystem, ploidy = 2)
plotMutations(mypop, mysystem)
## Only plot the 1st allele of each genes for the genes 1 to 5 and the individuals 1 to 3
plotMutations(mypop, mysystem, alleles = c("GCN1"), genes = 1:5,
 inds = c("Ind1", "Ind2", "Ind3"))
}
}
