% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_source_api.R
\name{source_bands}
\alias{source_bands}
\alias{.source_bands}
\alias{.source_bands_reap}
\alias{.source_bands_band_name}
\alias{.source_bands_resolution}
\alias{.source_bands_to_sits}
\alias{.source_bands_to_source}
\alias{.source_cloud}
\alias{.source_cloud_bit_mask}
\alias{.source_cloud_values}
\alias{.source_cloud_interp_values}
\title{Source bands functions}
\usage{
.source_bands(source, collection, ..., fn_filter = NULL, add_cloud = TRUE)

.source_bands_reap(
  source,
  collection,
  key,
  ...,
  bands = NULL,
  fn_filter = NULL,
  add_cloud = TRUE,
  default = NULL
)

.source_bands_band_name(source, collection, ..., bands = NULL)

.source_bands_resolution(
  source,
  collection,
  ...,
  bands = NULL,
  fn_filter = NULL,
  add_cloud = TRUE
)

.source_bands_to_sits(source, collection, bands)

.source_bands_to_source(source, collection, bands)

.source_cloud()

.source_cloud_bit_mask(source, collection)

.source_cloud_values(source, collection)

.source_cloud_interp_values(source, collection)
}
\arguments{
\item{source}{Valid data source.}

\item{collection}{Image collection.
source.}

\item{fn_filter}{A \code{function} that will be applied in each band
to filter selection. The provided function must have an input parameter to
receive band object and return a \code{logical} value.}

\item{add_cloud}{Should the cloud band be returned?}

\item{key}{Key of a band object.}

\item{bands}{Bands to be retrieved}

\item{default}{Value to be returned if an attribute or key is not
found.}
}
\value{
The values returned by each function are described as follows.

\code{.source_bands()} returns a \code{character} vector with bands
names

\code{.source_bands_reap()} returns any object stored in the
band attribute indicated by \code{key} parameter. If attribute is not
found, \code{default} value is returned.

\code{.source_bands_band_name()} returns a \code{character} vector.

\code{.source_bands_resolution()} returns a named \code{list}
containing \code{numeric} vectors with the spatial resolution of a band.

\code{.source_bands_to_sits()} returns a \code{character} vector
with all converted bands name.

\code{.source_bands_to_source()} returns a \code{character} vector
with all converted bands name.

\code{.source_cloud()} returns a \code{character} vector with cloud
band name.

\code{.source_cloud_bit_mask()} returns a \code{logical} value.

\code{.source_cloud_values()} returns a named \code{list} containing
all values/or bits description of a cloud band.

\code{.source_cloud_interp_values()} returns a \code{numeric}
vector with all values/or bits to be interpolated if found in the cloud band.
}
\description{
These functions provide an API to handle/retrieve data from bands.

\code{.source_bands()} lists all bands defined in a collection
that matches the criteria defined by its parameters. If no filter is
provided, all bands are returned.

\code{.source_bands_reap()} reaps the attributes' values
indicated by \code{key} argument for all bands filtered by its parameters.

\code{.source_bands_band_name()} returns the \code{band_name}
attribute of all bands filtered by its parameters.

\code{.source_bands_resolution()} returns the
\code{resolution} attribute of all bands filtered by its parameters.

\code{.source_bands_to_sits()} converts any bands to its
sits name indicated in band entry.

\code{.source_bands_to_source()} converts any bands to its
corresponding names indicated in \code{band_name} attribute.

\code{.source_cloud()} lists cloud band for a collection.

\code{.source_cloud_bit_mask()} returns the \code{bit_mask}
attribute of a cloud band, indicating if the cloud band is a bit mask.

\code{.source_cloud_values()} returns the \code{values}
attribute of a cloud band.

\code{.source_cloud_interp_values()} returns the
\code{interp_values} attribute of a cloud band, indicating which value/bit
must be interpolated (e.g. shadows, clouds).
}
\keyword{internal}
