% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_predictors.R
\name{sits_predictors}
\alias{sits_predictors}
\title{Obtain predictors for time series samples}
\usage{
sits_predictors(samples)
}
\arguments{
\item{samples}{Time series in sits format (tibble of class "sits")}
}
\value{
The predictors for the sample: a data.frame with one row per sample.
}
\description{
Predictors are X-Y values required for machine learning
algorithms, organized as a data table where each row corresponds
to a training sample. The first two columns of the predictors table
are categorical (\code{label_id} and \code{label}). The other columns are
the values of each band and time, organized first by band and then by time.
}
\examples{
if (sits_run_examples()) {
    pred <- sits_predictors(samples_modis_ndvi)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
