% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_geo_dist.R
\name{sits_geo_dist}
\alias{sits_geo_dist}
\title{Compute the minimum distances among samples and prediction points.}
\usage{
sits_geo_dist(samples, roi, n = 1000L, crs = "EPSG:4326")
}
\arguments{
\item{samples}{Time series (tibble of class "sits").}

\item{roi}{A region of interest (ROI), either a file containing a
shapefile or an "sf" object}

\item{n}{Maximum number of samples to consider
(integer)}

\item{crs}{CRS of the \code{samples}.}
}
\value{
A tibble with sample-to-sample and sample-to-prediction distances
        (object of class "distances").
}
\description{
Compute the minimum distances among samples and samples to prediction
points, following the approach proposed by Meyer and Pebesma(2022).
}
\note{
As pointed out by Meyer and Pebesma, many classifications using machine
learning assume that the reference data are independent and
well-distributed in space. In practice, many training samples are strongly
concentrated in some areas, and many large areas have no samples.
This function compares two distributions:
\enumerate{
\item{The distribution of the spatial distances of reference data
to their nearest neighbor (sample-to-sample.}
\item{The distribution of distances from all points of study area
to the nearest reference data point (sample-to-prediction).}
}
}
\examples{
if (sits_run_examples()) {
    # read a shapefile for the state of Mato Grosso, Brazil
    mt_shp <- system.file("extdata/shapefiles/mato_grosso/mt.shp",
        package = "sits"
    )
    # convert to an sf object
    mt_sf <- sf::read_sf(mt_shp)
    # calculate sample-to-sample and sample-to-prediction distances
    distances <- sits_geo_dist(
        samples = samples_modis_ndvi,
        roi = mt_sf
    )
    # plot sample-to-sample and sample-to-prediction distances
    plot(distances)
}
}
\references{
Meyer, H., Pebesma, E. "Machine learning-based global maps of
ecological variables and the challenge of assessing them",
Nature Communications 13, 2208 (2022).
https://doi.org/10.1038/s41467-022-29838-9
}
\author{
Alber Sanchez, \email{alber.ipia@inpe.br}

Rolf Simoes, \email{rolfsimoes@gmail.com}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
