% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_som.R
\name{sits_som_map}
\alias{sits_som_map}
\title{Build a SOM for quality analysis of time series samples}
\usage{
sits_som_map(
  data,
  grid_xdim = 10L,
  grid_ydim = 10L,
  alpha = 1,
  rlen = 100L,
  distance = "dtw",
  som_radius = 2L,
  mode = "online"
)
}
\arguments{
\item{data}{A tibble with samples to be clustered.}

\item{grid_xdim}{X dimension of the SOM grid (default = 25).}

\item{grid_ydim}{Y dimension of the SOM grid.}

\item{alpha}{Starting learning rate
(decreases according to number of iterations).}

\item{rlen}{Number of iterations to produce the SOM.}

\item{distance}{The type of similarity measure (distance). The
following similarity measurements are supported:
\code{"euclidean"} and \code{"dtw"}. The default
similarity measure is \code{"dtw"}.}

\item{som_radius}{Radius of SOM neighborhood.}

\item{mode}{Type of learning algorithm. The
following learning algorithm are available:
\code{"online"}, \code{"batch"}, and \code{"pbatch"}.
The default learning algorithm is \code{"online"}.}
}
\value{
\code{sits_som_map()} produces a list with three members:
(1) the samples tibble, with one additional column indicating
to which neuron each sample has been mapped;
(2) the Kohonen map, used for plotting and cluster quality measures;
(3) a tibble with the labelled neurons,
where each class of each neuron is associated to two values:
(a) the prior probability that this class belongs to a cluster
based on the frequency of samples of this class allocated to the neuron;
(b) the posterior probability that this class belongs to a cluster,
using data for the neighbours on the SOM map.
}
\description{
These function use self-organized maps to perform
quality analysis in satellite image time series.
}
\note{
\code{\link[sits]{sits_som_map}} creates a SOM map, where
high-dimensional data is mapped into a two dimensional map,
keeping the topological relations
between data patterns. Each sample is assigned to a neuron,
and neurons are placed in the grid based on similarity.

\code{\link[sits]{sits_som_evaluate_cluster}} analyses the neurons of
the SOM map, and builds clusters based on them. Each cluster is a neuron
or a set of neuron categorized with same label.
It produces a tibble with the percentage of mixture of classes
in each cluster.

\code{\link[sits]{sits_som_clean_samples}} evaluates sample quality
based on the results of the SOM map.  The algorithm identifies noisy samples,
using `prior_threshold` for the prior probability
and `posterior_threshold` for the posterior probability.
Each sample receives an evaluation tag, according to the following rule:
(a) If the prior probability is < `prior_threshold`, the sample is tagged
as "remove";
(b) If the prior probability is >= `prior_threshold` and the posterior
probability is >=`posterior_threshold`, the sample is tagged as "clean";
(c) If the prior probability is >= `posterior_threshold` and
the posterior probability is < `posterior_threshold`, the sample is tagged as
"analyze" for further inspection.

The user can define which tagged samples will be returned using the "keep"
parameter, with the following options: "clean", "analyze", "remove".

To learn more about the learning algorithms, check the
      \code{\link[kohonen:supersom]{kohonen::supersom}} function.

The \code{sits} package implements the \code{"dtw"} (Dynamic Time
      Warping) similarity measure. The \code{"euclidean"} similarity
      measurement come from the
      \code{\link[kohonen:supersom]{kohonen::supersom (dist.fcts)}} function.
}
\examples{
if (sits_run_examples()) {
    # create a som map
    som_map <- sits_som_map(samples_modis_ndvi)
    # plot the som map
    plot(som_map)
    # evaluate the som map and create clusters
    clusters_som <- sits_som_evaluate_cluster(som_map)
    # plot the cluster evaluation
    plot(clusters_som)
    # clean the samples
    new_samples <- sits_som_clean_samples(som_map)
}

}
\references{
Lorena Santos, Karine Ferreira, Gilberto Camara, Michelle Picoli,
Rolf Simoes, “Quality control and class noise reduction of satellite
image time series”. ISPRS Journal of Photogrammetry and Remote Sensing,
vol. 177, pp 75-88, 2021. https://doi.org/10.1016/j.isprsjprs.2021.04.014.
}
\author{
Lorena Alves, \email{lorena.santos@inpe.br}

Karine Ferreira. \email{karine.ferreira@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}
}
