% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_label.R
\name{to_character}
\alias{to_character}
\title{Convert variable into character vector and replace values with associated value labels}
\usage{
to_character(x, ..., add.non.labelled = FALSE, prefix = FALSE,
  var.label = NULL, drop.na = TRUE, drop.levels = FALSE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{add.non.labelled}{Logical, if \code{TRUE}, values without associated
value label will also be converted to labels (as is). See 'Examples'.}

\item{prefix}{Logical, if \code{TRUE}, the value labels used as factor levels
or character values will be prefixed with their associated values. See 'Examples'.}

\item{var.label}{Optional string, to set variable label attribute for the
returned variable (see vignette \href{https://cran.r-project.org/package=sjlabelled/vignettes/intro_sjlabelled.html}{Labelled Data and the sjlabelled-Package}).
If \code{NULL} (default), variable label attribute of \code{x} will
be used (if present). If empty, variable label attributes will be removed.}

\item{drop.na}{Logical, if \code{TRUE}, tagged \code{NA} values with value labels
will be converted to regular NA's. Else, tagged \code{NA} values will be replaced
with their value labels. See 'Examples' and \code{\link{get_na}}.}

\item{drop.levels}{Logical, if \code{TRUE}, unused factor levels will be
dropped (i.e. \code{\link{droplevels}} will be applied before returning
the result).}
}
\value{
A character vector with the associated value labels as values. If \code{x}
          is a data frame, the complete data frame \code{x} will be returned,
          where variables specified in \code{...} are coerced
          to character variables;
          if \code{...} is not specified, applies to all variables in the
          data frame.
}
\description{
This function converts (replaces) variable values (also of factors
               or character vectors) with their associated value labels and returns
               them as character vector. This is just a convenient wrapper for
               \code{as.character(to_label(x))}.
}
\note{
Value labels will be removed when converting variables to factors,
      variable labels, however, are preserved.
}
\examples{
library(sjlabelled)
data(efc)
print(get_labels(efc)['c161sex'])
head(efc$c161sex)
head(to_character(efc$c161sex))

print(get_labels(efc)['e42dep'])
table(efc$e42dep)
table(to_character(efc$e42dep))

head(efc$e42dep)
head(to_character(efc$e42dep))

# numeric values w/o value labels will also be converted into character
str(efc$e17age)
str(to_character(efc$e17age))


# factor with non-numeric levels, non-prefixed and prefixed
x <- factor(c("a", "b", "c"))
x <- set_labels(x, labels = c("ape", "bear", "cat"))

to_character(x, prefix = FALSE)
to_character(x, prefix = TRUE)


# create vector
x <- c(1, 2, 3, 2, 4, NA)
# add less labels than values
x <- set_labels(x,
                labels = c("yes", "maybe", "no"),
                force.labels = FALSE,
                force.values = FALSE)
# convert to character w/o non-labelled values
to_character(x)
# convert to character, including non-labelled values
to_character(x, add.non.labelled = TRUE)


# create labelled integer, with missing flag
library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1, 2:3),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# to character, with missing labels
to_character(x, drop.na = FALSE)
# to character, missings removed
to_character(x, drop.na = TRUE)
# keep missings, and use non-labelled values as well
to_character(x, add.non.labelled = TRUE, drop.na = FALSE)


# easily coerce specific variables in a data frame to character
# and keep other variables, with their class preserved
to_character(efc, e42dep, e16sex, c172code)

}
