% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_label.R
\name{to_label}
\alias{to_label}
\title{Convert variable into factor with associated value labels}
\usage{
to_label(x, ..., add.non.labelled = FALSE, prefix = FALSE,
  var.label = NULL, drop.na = TRUE, drop.levels = FALSE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
\code{\link[tidyselect]{select_helpers}}.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{add.non.labelled}{Logical, if \code{TRUE}, values without associated
value label will also be converted to labels (as is). See 'Examples'.}

\item{prefix}{Logical, if \code{TRUE}, the value labels used as factor levels
or character values will be prefixed with their associated values. See 'Examples'.}

\item{var.label}{Optional string, to set variable label attribute for the
returned variable (see vignette \href{https://cran.r-project.org/package=sjlabelled/vignettes/intro_sjlabelled.html}{Labelled Data and the sjlabelled-Package}).
If \code{NULL} (default), variable label attribute of \code{x} will
be used (if present). If empty, variable label attributes will be removed.}

\item{drop.na}{Logical, if \code{TRUE}, tagged \code{NA} values with value labels
will be converted to regular NA's. Else, tagged \code{NA} values will be replaced
with their value labels. See 'Examples' and \code{\link{get_na}}.}

\item{drop.levels}{Logical, if \code{TRUE}, unused factor levels will be
dropped (i.e. \code{\link{droplevels}} will be applied before returning
the result).}
}
\value{
A factor with the associated value labels as factor levels. If \code{x}
          is a data frame, the complete data frame \code{x} will be returned,
          where variables specified in \code{...} are coerced to factors;
          if \code{...} is not specified, applies to all variables in the
          data frame.
}
\description{
This function converts (replaces) values of a variable (also of factors
               or character vectors) with their associated value labels. Might
               be helpful for factor variables.
               For instance, if you have a Gender variable with 0/1 value, and associated
               labels are male/female, this function would convert all 0 to male and
               all 1 to female and returns the new variable as factor.
}
\note{
Value label attributes will be removed when converting variables to factors.
      \cr \cr
      This function is kept for backwards-compatibility. It is preferred to
      use \code{\link[sjlabelled]{as_label}}.
}
\examples{
library(sjlabelled)
data(efc)
print(get_labels(efc)['c161sex'])
head(efc$c161sex)
head(to_label(efc$c161sex))

# Find more examples at '?sjlabelled::as_label'

}
