% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta_sq.R
\name{eta_sq}
\alias{eta_sq}
\alias{omega_sq}
\alias{cohens_f}
\alias{anova_stats}
\title{Effect size statistics for anova}
\usage{
eta_sq(model, partial = FALSE, ci.lvl = NULL, n = 1000)

omega_sq(model, partial = FALSE, ci.lvl = NULL, n = 1000)

cohens_f(model)

anova_stats(model, digits = 3)
}
\arguments{
\item{model}{A fitted anova-model of class \code{aov} or \code{anova}. Other
models are coerced to \code{\link[stats]{anova}}.}

\item{partial}{Logical, if \code{TRUE}, the partial eta-squared is returned.}

\item{ci.lvl}{Scalar between 0 and 1. If not \code{NULL}, returns a data
frame with effect sizes including lower and upper confidence intervals.}

\item{n}{Number of bootstraps to be generated.}

\item{digits}{Number of decimal points in the returned data frame.}
}
\value{
A data frame with the term name(s) and effect size statistics; if
  \code{ci.lvl} is not \code{NULL}, a data frame including lower and
  upper confidence intervals is returned. For \code{anova_stats()}, a tidy
  data frame with all statistics is returned (excluding confidence intervals).
}
\description{
Returns the (partial) eta-squared, (partial) omega-squared statistic
  or Cohen's F for all terms in an anovas. \code{anova_stats()} returns
  a tidy summary, including all these statistics and power for each term.
}
\details{
For \code{eta_sq()} (with \code{partial = FALSE}), due to
  non-symmetry, confidence intervals are based on bootstrap-methods. In this
  case, \code{n} indicates the number of bootstrap samples to be drawn to
  compute the confidence intervals.
  \cr \cr
  For partial eta-squared (\code{eta_sq()} with \code{partial = TRUE}),
  confidence intervals are based on \code{\link[apaTables]{get.ci.partial.eta.squared}}
  and for omega-squared, confidence intervals are based on
  \code{\link[MBESS]{conf.limits.ncf}}. Confidence intervals for partial
  omega-squared is also based on bootstrapping.
}
\examples{
# load sample data
data(efc)

# fit linear model
fit <- aov(
  c12hour ~ as.factor(e42dep) + as.factor(c172code) + c160age,
  data = efc
)

eta_sq(fit)
omega_sq(fit)
eta_sq(fit, partial = TRUE)

# CI for omega squared requires MBESS packages
if (requireNamespace("MBESS", quietly = TRUE)) {
  omega_sq(fit, ci.lvl = .95)
}

anova_stats(car::Anova(fit, type = 2))

}
\references{
Levine TR, Hullett CR (2002): Eta Squared, Partial Eta Squared, and Misreporting of Effect Size in Communication Research (\href{https://www.msu.edu/~levinet/eta\%20squared\%20hcr.pdf}{pdf})
}
