% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight.R
\name{weight2}
\alias{weight2}
\title{Weight a variable}
\usage{
weight2(x, weights)
}
\arguments{
\item{x}{(Unweighted) variable}

\item{weights}{Vector with same length as \code{x}, which
contains weight factors. Each value of \code{x} has a
specific assigned weight in \code{weights}.}
}
\value{
The weighted \code{x}.
}
\description{
This function weights the variable \code{x} by
               a specific vector of \code{weights}. It's an
               alternative weight calculation to \code{\link{weight}},
               though \code{\link{weight}} usage is recommended.
}
\details{
This function sums up all \code{weights} values of the associated
           categories of \code{x}, whereas the \code{\link{weight}} function
           uses a \code{\link{xtabs}} formula to weight cases. Thus, this function
           may return a vector of different length than \code{x}.
}
\note{
See 'Note' in \code{\link{weight}}
}
\examples{
v <- sample(1:4, 20, TRUE)
table(v)
w <- abs(rnorm(20))
table(weight2(v, w))


}
\seealso{
\code{\link{weight}}
}

