% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{bernoulli.trial}
\alias{bernoulli.trial}
\title{Execute a (series of) Bernoulli trial(s)}
\usage{
bernoulli.trial(n, p, r, type = "tail")
}
\arguments{
\item{n}{Total number of structures}

\item{p}{Probability of target (e.g. ratio of azimuths)}

\item{r}{Number of structures orientated towards target (hits)}

\item{type}{(Optional) Type of probability to output. Possibilities are: (a) \emph{single}
in which case the result of a single Bernoulli trial is reported; or (b) \emph{tail} in
which case it calculates Bernoulli trials for all hit values between 1 and (r-1) and then
outputs 1 minus the calculated probability. The latter is effectively a p-value. Default is \emph{tail}}
}
\description{
This function allows one to calculate the probability of having r structures
out of n, orientated towards a target with probability p.
}
\examples{
# probability of having at least 10 out of 30 structures
# aligned to targets covering 20\% of the horizon
bernoulli.trial(30, 0.2, 10)
}
\references{
Ruggles, C (1999) \emph{Astronomy in Prehistoric Britain and Ireland}. Yale University Press.
}
