#' Gather League Draft Information
#'
#' Given a league ID, gather draft information for that league.
#'
#' @return Returns a data frame containing draft information for that league.
#' @author Nick Bultman, \email{njbultman74@@gmail.com}, December 2021
#' @keywords draft league
#' @importFrom httr GET content
#' @importFrom jsonlite fromJSON
#' @export
#' @examples
#' \dontrun{get_league_drafts(688281863499907072)}
#'
#' @param league_id League ID generated by Sleeper (numeric or character)
#'
get_league_drafts <- function(league_id) {
  # Send request to API given league ID specified
  x <- jsonlite::fromJSON(httr::content(httr::GET(paste0("https://api.sleeper.app/v1/league/", league_id, "/drafts")), as = "text"))
  # Check if class of data returned from request is list
  if(inherits(x, "list")) {
    # If class is list, it is an empty list and no data was found - inform user and do not return anything
    message("No data found - was the league ID entered correctly?")
  } else {
    # If class is not list, a data frame is returned and data was found - return data
    return(x)
  }
}
