% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slm-main.R
\name{cov_kernel}
\alias{cov_kernel}
\title{Kernel estimation: bootstrap method}
\usage{
cov_kernel(epsilon, model_selec = -1,
 model_max = min(50,length(epsilon)/2), kernel_fonc = triangle,
 block_size = length(epsilon)/2, block_n = 100, plot = FALSE)
}
\arguments{
\item{epsilon}{an univariate process.}

\item{model_selec}{the order of the method. If \code{model_selec = -1}, the method chooses
the treshold automatically. If \code{model_selec = k}, then only \code{k} autocovariance terms are kept
and smoothed by the kernel.}

\item{model_max}{the maximal order.}

\item{kernel_fonc}{define the kernel to use in the method. The user can give his own kernel function.}

\item{block_size}{size of the bootstrap blocks. \code{block_size} must be greater than \code{model_max}.}

\item{block_n}{blocks number to use for the bootstrap.}

\item{plot}{logical. By default, \code{plot = FALSE}. If \code{plot = TRUE}, the risk curve is returned and the
ACF of the process.}
}
\value{
The method returns the tapered autocovariance vector with \code{model_selec} autocovariance terms.
 \item{model_selec}{the number of selected autocovariance terms.}
 \item{cov_st}{the estimated autocovariances.}
}
\description{
This method estimates the spectral density and the autocovariances of the error process via a lag-window
 (or kernel) estimator (see P.J. Brockwell and R.A. Davis (1991). Time Series: Theory and Methods. \emph{Springer Science & Business Media},
 page 330). The weights are computed according to a kernel \eqn{K} and a bandwidth \eqn{h} (or a lag),
 to be chosen by the user. The lag can be computed automatically by using a bootstrap technique (via the \code{\link[slm:Rboot]{Rboot}} function).
}
\examples{
x = arima.sim(list(ar=c(0.7)),1000)
cov_kernel(x, model_selec = -1, block_n = 10, plot = TRUE)
}
\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.

 W.B. Wu, M. Pourahmadi (2009). Banding sample autocovariance matrices of stationary processes. \emph{Statistica Sinica}, pp. 1755–1768.
}
