% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary-fun.R
\name{cov_matrix_estimator}
\alias{cov_matrix_estimator}
\title{Covariance matrix estimator for slm object}
\usage{
cov_matrix_estimator(object)
}
\arguments{
\item{object}{an object of class \code{slm}.}
}
\value{
This function returns the covariance matrix estimator.
}
\description{
This function gives the estimation of the asymptotic covariance matrix of the least squares estimator in the case of the linear regression
 model with strictly stationary errors.
}
\details{
The function computes the covariance matrix estimator of the least squares estimator from the vector \code{cov_st}
 of a \code{slm} object. If the user has given the argument \code{Cov_ST} in the \code{slm} object, then it is used
 to compute the final covariance matrix.
 For the methods "efromovich", "kernel" and "select", the covariance matrix estimator may not be positive definite. Then we apply the
 "Positive definite projection" algorithm, which consists in replacing all eigenvalues lower or equal to zero with the smallest
 positive eigenvalue of the covariance matrix.
}
\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
