% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm2.R
\name{sm2_encrypt_to_file}
\alias{sm2_encrypt_to_file}
\alias{sm2_decrypt_from_file}
\title{SM2 Encrypt/Decrypt - file}
\usage{
sm2_encrypt_to_file(data, enc_file, public_key)

sm2_decrypt_from_file(dec_file, private_key)
}
\arguments{
\item{data}{data to be encrypted, must be a raw vector}

\item{enc_file}{the enctypted file to be saved}

\item{public_key}{a public key represented as a hexadecimal string}

\item{dec_file}{the encrypted file to be loaded}

\item{private_key}{a private key represented as a hexadecimal string}
}
\value{
\describe{
  \item{\link{sm2_encrypt_to_file}}{returns nothing, an encrypted file will be saved in the specified path}
  \item{\link{sm2_decrypt_from_file}}{returns nothing, a decrypted file will be saved in the specified path}
}
}
\description{
For ease of use, we have provided functions to encrypt or decrypt data directly from files.
}
\examples{
## encrypt and decrypt from file
\dontrun{
  data <- 'abc' |> charToRaw()
  keypair <- sm2_gen_keypair()
  private_key <- keypair$private_key
  public_key <- keypair$public_key
  sm2_encrypt_to_file(data, 'data.enc', public_key)
  sm2_decrypt_from_file('data.enc', private_key)
}

}
