% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.autoplot.R
\name{autoplot.smoof_function}
\alias{autoplot.smoof_function}
\title{Generate \code{\link[ggplot2]{ggplot}} object.}
\usage{
\method{autoplot}{smoof_function}(x, show.optimum = FALSE,
  render.levels = FALSE, render.contours = TRUE, use.facets = FALSE, ...)
}
\arguments{
\item{x}{[\code{smoof_function}]\cr
Objective function.}

\item{show.optimum}{[\code{logical(1)}]\cr
If the function has a known global optimum, should its location be
plotted by a point or multiple points in case of multiple global optima?
Default is \code{FALSE}.}

\item{render.levels}{[\code{logical(1)}]\cr
For 2D numeric functions only: Should an image map be plotted? Default is
\code{FALSE}.}

\item{render.contours}{[\code{logical(1)}]\cr
For 2D numeric functions only: Should contour lines be plotted? Default is
\code{TRUE}.}

\item{use.facets}{[\code{logical(1)}]\cr
For mixed functions only: Should the plot be splitted by the discrete values
or should the different values be distinguished by colour in a single plot?
Default is \code{FALSE}.}

\item{...}{[any]\cr
Not used.}
}
\value{
[\code{\link[ggplot2]{ggplot}}]
}
\description{
Generate \code{\link[ggplot2]{ggplot}} object.
}
\examples{
library(ggplot2)
fn = makeHimmelblauFunction()
print(autoplot(fn))
print(autoplot(fn, render.levels = TRUE, render.contours = FALSE))
print(autoplot(fn, show.optimum = TRUE))
}

