\name{dst}
\alias{dst}
\alias{pst}
\alias{qst}
\alias{rst}
\title{
Skew-t Distribution
}
\description{
Density function, distribution function and random number
generation for the skew-t (ST) distribution.
}
\synopsis{
dst(x, location = 0, scale = 1, shape = 0, df = Inf, dp = NULL, log = FALSE) 
pst(x, location = 0, scale = 1, shape = 0, df = Inf, dp = NULL, ...)
qst(p, location = 0, scale = 1, shape = 0, df = Inf, tol = 1e-08, dp = NULL, ...)
rst(n = 1, location = 0, scale = 1, shape = 0, df = Inf, dp = NULL)
}
\usage{
dst(x, location=0, scale=1, shape=0, df=Inf, log=FALSE)
dst(x, dp=, log=FALSE)
pst(x, location=0, scale=1, shape=0, df=Inf, ...)
pst(x, dp=, log=FALSE)
qst(p, location=0, scale=1, shape=0, df=Inf, tol=1e-8, ...)
qst(x, dp=, log=FALSE)
rst(n=1, location=0, scale=1, shape=0, df=Inf)
rst(x, dp=, log=FALSE)
}
\arguments{
\item{x}{
vector of quantiles. Missing values (\code{NA}s) are allowed.
}
\item{p}{
  vector of probabililities
  }
\item{location}{
vector of location parameters.
}
\item{scale}{
vector of (positive) scale parameters.
}
\item{shape}{
vector of shape parameters. With \code{pst} and \code{qst}, 
it must be of length 1.
}
\item{df}{
degrees of freedom (scalar); default is \code{df=Inf} which corresponds 
to the skew-normal distribution.
}
\item{dp}{
a vector of length 4, whose elements represent location, scale (positive),
shape and df, respectively.  If \code{dp} is specified, the individual
parameters cannot be set.
}
\item{n}{
sample size.
}
\item{log}{ 
logical; if TRUE, densities  are given as log-densities.
}
\item{tol}{
  a scalar value which regulates the accuracy of the result of
  \code{qsn}.
}
\item{...}{additional parameters passed to \code{integrate}.
}}
\value{
Density (\code{dst}), probability (\code{pst}), quantiles (\code{qst}) 
and random sample (\code{rst}) from the skew-t distribution with given 
\code{location}, \code{scale}, \code{shape} and \code{df} parameters.
}
\section{Background}{
The family of skew-t distributions is an extension of the Student's t
family, via the introduction of a \code{shape} parameter which regulates
skewness; when \code{shape=0}, the skew-t distribution reduces to the
usual Student's t distribution. When \code{df=Inf}, it reduces to the 
skew-normal distribution. A multivariate version of the distribution exists.
See the reference below for additional information.
}
\references{
Azzalini, A. and Capitanio, A. (2003).
Distributions generated by perturbation of symmetry 
with emphasis on a multivariate skew-\emph{t} distribution.
\emph{J.Roy. Statist. Soc. B} 
\bold{65}, 367--389.
  }
\seealso{
\code{\link{dmst}}, \code{\link{dsn}},  \code{\link{psn}}
  }
\examples{
pdf <- dst(seq(-4,4,by=0.1), shape=3, df=5)
rnd <- rst(100, 5, 2, -5, 8)
q <- qst(c(0.25,0.5,0.75), shape=3, df=5)
pst(q, shape=3, df=5)  # must give back c(0.25,0.5,0.75)

}
\keyword{distribution}

