% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_design_rule.R
\name{check_design_rule}
\alias{check_design_rule}
\title{Internal helper to test the design rules for any string and setting of \code{to_any_case()}}
\usage{
check_design_rule(string, preprocess = NULL,
  replace_special_characters = FALSE, postprocess = NULL, prefix = "",
  postfix = "", unique_sep = NULL, empty_fill = NULL,
  parsing_option = 1)
}
\arguments{
\item{string}{A string (for example names of a data frame).}

\item{preprocess}{String that will be wrapped internally into \code{stringr::regex()}. 
All matches will be treated as additional splitting parameters besides the default ones 
(\code{"_"} and \code{" "}), when parsing the input string.}

\item{replace_special_characters}{Logical, if \code{TRUE}, special characters 
will be translated to characters which are more likely to be understood by 
different programs. For example german umlauts will be translated to ae, oe, ue etc.}

\item{postprocess}{String that will be used as separator. The defaults are \code{"_"} 
and \code{""}, regarding the specified \code{case}.}

\item{prefix}{prefix (string).}

\item{postfix}{postfix (string).}

\item{unique_sep}{A string. If it is supplied, then duplicated names will get a suffix integer
in the order of their appearance. The suffix is separated by the supplied string to this argument.}

\item{empty_fill}{A string. If it is supplied, then each entry that matches "" will be replaced
by the supplied string to this argument.}

\item{parsing_option}{An integer (1 (default), 2 or 3) that will determine the parsing option.
1: RRRStudio -> RRR_Studio
2: RRRStudio -> RRRS_tudio
If another integer is supplied, no parsing regarding the pattern of upper- and lowercase will appear.}
}
\value{
A character vector separated by underscores, containing the parsed string.
}
\description{
Internal helper to test the design rules for any string and setting of \code{to_any_case()}
}
\author{
Malte Grosser, \email{malte.grosser@gmail.com}
}
\keyword{utilities}
