% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sk_methods.R
\name{as.matrix.sk}
\alias{as.matrix.sk}
\title{convert to matrix}
\usage{
\method{as.matrix}{sk}(x, rownames.force = NA, layer = 1, ...)
}
\arguments{
\item{x}{a sk object}

\item{rownames.force}{ignored}

\item{layer}{integer, for multi-layer grids, the layer number to return}

\item{...}{further arguments to as.matrix}
}
\value{
the grid data as a matrix
}
\description{
Returns a matrix representation of the grid data. This is shorthand for
extracting the data using \code{x[]} (single layer) or \code{x[,j]} (multi-layer),
then passing the result to \code{matrix} along with \code{dim(x)}.
}
\examples{
g = sk_validate(list(gval=stats::rnorm(4^2), gdim=4, gres=0.5))
plot(g)
as.matrix(g)
}
