% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtable_associations.R
\name{gtable_ld_associations_gdata}
\alias{gtable_ld_associations_gdata}
\title{Gtable of linkage disequilibrium and associations using a GenotypeData object}
\usage{
gtable_ld_associations_gdata(
  df_assocs,
  gdata,
  pvalue_colname = "pvalues",
  labels_colname = "probe_id",
  diamonds = nrow(df_assocs) <= 40,
  window = 15,
  ...
)
}
\arguments{
\item{df_assocs}{SNP annotation data frame with columns chromosome,
position, and as specified by parameters pvalue_colname
and optionally labels_colname.}

\item{gdata}{GenotypeData object, as returned by
load_gds_as_genotype_data}

\item{pvalue_colname}{Column name of df_snp with association values}

\item{labels_colname}{Optional column name of df_snp with labels.
Set NULL to remove labels.}

\item{diamonds}{Should the values be displayed as diamonds or points ?
Default is TRUE for up to 40 SNPs.}

\item{window}{Window size for snprelate_ld.
Forced to the total number of SNPs if diamonds is FALSE}

\item{...}{Passed to gtable_ld_associations}
}
\value{
gtable
}
\description{
Compute linkage disequilibrium using snprelate_ld on the set of SNPs in the
associations data frame and call gtable_ld_associations.
Creates a gtable of a linkage disequilibrium, chromosomic positions, and
association scores ggplots.
}
