% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PowerRelation.R
\name{elementLookup}
\alias{elementLookup}
\title{Element lookup}
\usage{
elementLookup(powerRelation, element)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{element}{an element in \code{powerRelation$elements}}
}
\value{
List of tuples, each of size 2.
First value of a tuple indicates the equivalence class index,
the second value the index inside that equivalence class with the coalition containing the element.
Returns \code{NULL} if the element does not exist.
}
\description{
List coalitions that an element appears in.
}
\details{
This function calls \code{powerRelation$elementLookup(element)}.
The returned list contains tuples containing the index to find the corresponding coalitions in \code{powerRelation$eqs}.

If  \code{elementLookup(powerRelation, 2)} returns \code{list(c(1,1), c(1,2), c(3,1))}, we can determine that the element \code{2}
appears twice in equivalence class \code{1} and once in equivalence class \code{3}.
The specific coalition then can be accessed with \code{powerRelation$eqs[[i]][[j]]}, where \code{i} is the equivalence class index
and \code{j} is the coalition in that equivalence class containing the element.
}
\examples{
pr <- as.PowerRelation("12 > 2 ~ 1")

l <- elementLookup(pr, 1)
l
# (1,1), (2,2)

sapply(l, function(tuple) 1 \%in\% pr$eqs[[tuple[1]]][[tuple[2]]]) |> all() |> stopifnot()

# if element does not exist, it returns NULL
elementLookup(pr, 3) |> is.null() |> stopifnot()

}
\seealso{
Other lookup functions: 
\code{\link{coalitionsAreIndifferent}()},
\code{\link{equivalenceClassIndex}()}
}
\concept{lookup functions}
