% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_create.r
\name{db_create}
\alias{db_create}
\title{Create a database.}
\usage{
db_create(cushion, dbname, delifexists = FALSE, as = "list", ...)
}
\arguments{
\item{cushion}{A \code{Cushion} object. Required.}

\item{dbname}{Database name}

\item{delifexists}{If TRUE, delete any database of the same name before creating it.
This is useful for testing. Default is FALSE.}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to one of the HTTP verbs (e.g,.
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, \code{\link[httr]{PUT}},
etc.)}
}
\value{
JSON as a character string or a list (determined by the
\code{as} parameter)
}
\description{
Create a database.
}
\examples{
\dontrun{
(x <- Cushion$new())

if ("leothelion" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="leothelion"))
}
db_create(x, dbname='leothelion')

## see if its there now
db_list(x)
}
}

