\name{DT_wheat}
\alias{DT_wheat}
\alias{GT_wheat}
\title{wheat lines dataset}
\description{

Information from a collection of 599 historical CIMMYT wheat lines.  The wheat data set is from 
CIMMYT's Global Wheat Program. Historically, this program has conducted numerous international 
trials across a wide variety of wheat-producing environments. The environments represented in 
these trials were grouped into four basic target sets of environments comprising four 
main agroclimatic regions previously defined and widely used by CIMMYT's Global Wheat Breeding Program. 
The phenotypic trait considered here was the average grain yield (GY) of the 599 wheat lines evaluated 
in each of these four mega-environments. 

A pedigree tracing back many generations was available, and the Browse application of 
the International Crop Information System (ICIS), as described in  (McLaren \emph{et al.} 2000, 2005) was used 
for deriving the relationship matrix A among the 599 lines; it accounts for selection and inbreeding.

Wheat lines were recently genotyped using 1447 Diversity Array Technology (DArT) generated by 
Triticarte Pty. Ltd. (Canberra, Australia; http://www.triticarte.com.au). The DArT markers 
may take on two values, denoted by their presence or absence. Markers with a minor allele frequency 
lower than 0.05 were removed, and missing genotypes were imputed with samples from the marginal 
distribution of marker genotypes, that is, \eqn{x_{ij}=Bernoulli(\hat p_j)}, where  \eqn{\hat p_j}  
is the estimated allele frequency computed from the non-missing genotypes. The number of DArT 
MMs after edition was 1279.

}

\usage{
  data(DT_wheat)
}

\format{
 Matrix Y contains the average grain yield, column 1: Grain yield for environment 1 and so on. 
}

\source{
  International Maize and Wheat Improvement Center (CIMMYT), Mexico.
}

\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

McLaren, C. G., L. Ramos, C. Lopez, and W. Eusebio. 2000. ``Applications of the geneaology manegment system.'' 
In \emph{International Crop Information System. Technical  Development Manual, version VI}, edited by McLaren, C. G., J.W. White 
and P.N. Fox. pp. 5.8-5.13. CIMMyT, Mexico: CIMMyT and IRRI. 

McLaren, C. G., R. Bruskiewich, A.M. Portugal, and A.B. Cosico. 2005. The International Rice Information System. 
A platform for meta-analysis of rice crop data. \emph{Plant Physiology} \bold{139}: 637-642.
}
\examples{

####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples using
#### command + shift + C |OR| control + shift + C
####=========================================####
# data(DT_wheat)
# DT <- DT_wheat
# GT <- GT_wheat
# DTlong <- data.frame(pheno=as.vector(DT), 
#                      env=sort(rep(1:4,nrow(DT))), 
#                      id=rep(rownames(DT),4))
# DT <- as.data.frame(DT);colnames(DT) <- paste0("x",1:4);DT$line <- rownames(DT);
# rownames(GT) <- DT$line
# K <- A.mat(GT) # additive relationship matrix
# K[1:4,1:4]
# ###=========================================####
# ###=========================================####
# ### using formula based 'mmes'
# ###=========================================####
# ###=========================================####
# head(DT)
# #### univariate
# mix0 <- mmes(x1~1,
#              random = ~vsm(ism(line),Gu=K),
#              rcov=~units,
#              data=DT)
# summary(mix0)$varcomp
# # if using mmes=TRUE provide Gu as inverse
# Ki <- solve(K + diag(1e-4,ncol(K),ncol(K)))
# Ki <- as(as(as( Ki,  "dMatrix"), "generalMatrix"), "CsparseMatrix")

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmes}} }
