% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms2samples.R
\name{ms2samples}
\alias{ms2samples}
\title{Convert between time and number of samples in sound files}
\usage{
ms2samples(value, fs = 300000, tx = 1, inv = FALSE)
}
\arguments{
\item{value}{Integer. Number of samples or time in ms.}

\item{fs}{Integer. The sampling frequency in samples per second.}

\item{tx}{Integer. Indicating the time expansion factor. If the
recording is not time expanded tx must be set to 1 (the default).}

\item{inv}{Logical. If TRUE converts time to number of samples, if FALSE
number of samples to time.}
}
\value{
Integer. If inv = TRUE returns number of samples, if inv = FALSE
returns time in ms.
}
\description{
Convert time to number of samples or vice versa
in sound files.
}
\examples{
ms2samples(150000, fs = 300000, tx = 1, inv = FALSE)
ms2samples(100, fs = 300000, tx = 1, inv = TRUE)
}
\author{
Bruno Silva
}
