% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_analyze.R
\name{getPitchCep}
\alias{getPitchCep}
\title{Cepstral pitch tracker}
\usage{
getPitchCep(frame, cepZp, samplingRate, pitchFloor, pitchCeiling, cepThres,
  cepSmooth, nCands)
}
\arguments{
\item{frame}{the real part of the spectrum of a frame, as returned by
\code{\link[stats]{fft}}}

\item{cepZp}{zero-padding of the spectrum used for cepstral pitch detection
(final length of spectrum after zero-padding in points, e.g. 2 ^ 13)}

\item{samplingRate}{sampling rate (Hz)}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{cepThres}{(0 to 1) separate
voicing thresholds for detecting pitch candidates with three different
methods: autocorrelation, cepstrum, and BaNa algorithm (see Details). Note
that HNR is calculated even for unvoiced frames.}

\item{cepSmooth}{the width of smoothing interval (Hz) for finding peaks in
the cepstrum}

\item{nCands}{maximum number of pitch candidates per method (except for
\code{dom}, which returns at most one candidate per frame), normally 1...4}
}
\value{
Returns either NULL or a dataframe of pitch candidates.
}
\description{
Internal soundgen function.
}
\details{
Attempts to find F0 of a frame by looking for peaks in the cepstrum.
See http://www.phon.ucl.ac.uk/courses/spsci/matlab/lect10.html
}
\keyword{internal}
