% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{.pitchDescriptives}
\alias{.pitchDescriptives}
\title{Pitch descriptives per file}
\usage{
.pitchDescriptives(
  time,
  pitch,
  smoothBW,
  inflThres,
  extraSummaryFun = c(),
  ref = 16.35,
  plot = FALSE,
  main = ""
)
}
\arguments{
\item{time}{a vector of time stamps in s}

\item{pitch}{a vector of pitch values in Hz}

\item{smoothBW}{a vector of bandwidths (Hz) for consecutive smoothing of
input using \code{\link{pitchSmoothPraat}}; NA = no smoothing}

\item{inflThres}{minimum difference (in semitones) between consecutive
extrema to consider them inflections; to apply a different threshold at
each smoothing level, provide \code{inflThres} as a vector of the same
length as \code{smoothBW}; NA = no threshold}

\item{extraSummaryFun}{additional summary function(s) that take a numeric
vector with some NAs and return a single number, eg c('myFun1', 'myFun2')}

\item{ref}{reference value for transforming Hz to semitones, defaults to
C0 (16.35 Hz)}

\item{plot}{if TRUE, plots the inflections for manual verification}
}
\description{
Internal soundgen function.
}
\keyword{internal}
