% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulationSpectrum.R
\name{modulationSpectrumFragment}
\alias{modulationSpectrumFragment}
\title{Modulation spectrum per fragment}
\usage{
modulationSpectrumFragment(
  sound,
  samplingRate,
  windowLength,
  windowLength_points,
  step,
  step_points,
  wn = "hanning",
  zp = 0,
  logSpec = FALSE,
  power = 1,
  normalize = TRUE
)
}
\arguments{
\item{sound}{numeric vector}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, rectangular, blackman, flattop}

\item{zp}{window length after zero padding, points}

\item{logSpec}{if TRUE, the spectrogram is log-transformed prior to taking 2D
FFT}

\item{power}{raise modulation spectrum to this power (eg power = 2 for ^2, or
"power spectrum")}

\item{normalize}{if TRUE, the modulation spectrum of each analyzed fragment
\code{maxDur} in duration is separately normalized to have max = 1}
}
\description{
Internal soundgen function.
}
\examples{
s = soundgen(amFreq = 25, amDep = 100)
ms = soundgen:::modulationSpectrumFragment(s, 16000,
  windowLength = 50, windowLength_points = .05 * 16000,
  step = 5, step_points = .005 * 16000)
image(as.numeric(colnames(ms$ms_half)), as.numeric(rownames(ms$ms_half)),
      t(log(ms$ms_half)))
}
\keyword{internal}
