% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothContours.R
\name{splitContour}
\alias{splitContour}
\title{Split contour}
\usage{
splitContour(anchors, discontThres = 0.05, jumpThres = 0.01)
}
\arguments{
\item{anchors}{a dataframe with two columns: time and value (time on any scale)}

\item{discontThres}{if two anchors are closer in time than
\code{discontThres} (on a 0-1 scale, ie specified as proportion of total
length), the contour is broken into segments with a linear transition
between these segments}

\item{jumpThres}{if anchors are closer than \code{jumpThres}, a new section
starts with no transition at all (e.g. for adding pitch jumps)}
}
\value{
Returns a dataframe containing the index of anchor rows for start and
  end of each segment and whether we want a transition or a jump between
  segments.
}
\description{
Internal soundgen function
}
\details{
Splits a smooth contour into several segments. A new segments is started if
the time step between two anchors is smaller than discontThres.
}
\examples{
soundgen:::splitContour(data.frame(time = c(0, 370, 650, 655, 1050, 1400),
  value = c(360, 316, 345, 550, 610, 590)))
soundgen:::splitContour(data.frame(time = c(0, .2, .205, .8, .81, 1),
  value = c(360, 316, 345, 550, 610, 590)))
soundgen:::splitContour(data.frame(time = c(0, .4, .45, .6, .8, 1),
  value = c(360, 316, 345, 550, 610, 590)))
soundgen:::splitContour(data.frame(time = c(0, .4, .45, .6, .8, 1),
  value = c(360, 316, 345, 550, 610, 590)),
  discontThres = .1)
soundgen:::splitContour(data.frame(time = c(0, 1),
  value = c(360, 590)))
}
\keyword{internal}
