% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulationSpectrum.R
\name{getAM}
\alias{getAM}
\title{Get amplitude modulation}
\usage{
getAM(m, amRange = c(10, 100), amRes = NULL)
}
\arguments{
\item{m}{numeric matrix of non-negative values with colnames giving temporal
modulation frequency}

\item{amRange}{the range of temporal modulation frequencies that we are
interested in as "amplitude modulation" (AM), Hz}

\item{amRes}{controls the width of window over which we look for local maxima}
}
\value{
Returns a list with the frequency (Hz) and depth of amplitude
  modulation (dB relative to global max, normally at 0 Hz).
}
\description{
Internal soundgen function
}
\details{
Helper function for calculating amplitude modulation based on the modulation
spectrum. Algorithm: averages AM across all FM bins in the positive half of
the modulation spectrum and looks for a peak in the specified AM frequency
range.
}
\keyword{internal}
