% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourcetools.R
\name{tokenize_file}
\alias{tokenize_file}
\alias{tokenize_string}
\title{Tokenize R Code}
\usage{
tokenize_file(path)

tokenize_string(string)
}
\arguments{
\item{path}{A file path.}

\item{string}{\R code as a character vector of length one.}
}
\value{
A \code{data.frame} with the following columns:

\tabular{ll}{
\code{value}  \tab The token's contents, as a string.     \cr
\code{row}    \tab The row where the token is located.    \cr
\code{column} \tab The column where the token is located. \cr
\code{type}   \tab The token type, as a string.           \cr
}
}
\description{
Tools for tokenizing \R code.
}
\note{
New rows are determined by existence of the \code{\\n}
line feed character, under the assumption that code being tokenized
will use either \code{\\n} to indicate newlines (as on modern
Linux and OS X systems), or \code{\\r\\n} as on Windows.
}
\examples{
tokenize_string("x <- 1 + 2")
}

