% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinar_est.R
\name{spinar_est}
\alias{spinar_est}
\title{Semiparametric estimation of INAR models}
\usage{
spinar_est(x, p)
}
\arguments{
\item{x}{[\code{integer}]\cr
vector with integer observations.}

\item{p}{[\code{integer(1)}]\cr
order of the INAR model, where \eqn{\code{p} \in \{1,2\}}.}
}
\value{
Vector containing the estimated coefficients \eqn{\code{alpha}_1,...,\code{alpha}_p} and the estimated entries
of the pmf \eqn{\code{pmf}_0, \code{pmf}_1},... where \eqn{\code{pmf}_i} represents the probability of
an innovation being equal to \eqn{i}.
}
\description{
Semiparametric estimation of the autoregressive parameters and the innovation
distribution of INAR(\code{p}) models, \eqn{\code{p} \in \{1,2\}}. The
estimation is conducted by maximizing the conditional likelihood of the model.
}
\examples{
# generate data
dat1 <- spinar_sim(n = 200, p = 1, alpha = 0.5,
                   pmf = c(0.3, 0.3, 0.2, 0.1, 0.1))
dat2 <- spinar_sim(n = 200, p = 2, alpha = c(0.2, 0.3),
                   pmf = c(0.25, 0.2, 0.15, 0.1, 0.1, 0.1, 0.1))

\donttest{
# semiparametric estimation of INAR(1) model
spinar_est(x = dat1, p = 1)
# semiparametric estimation of INAR(2) model
spinar_est(x = dat2, p = 2)}

}
