% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/border_correction.R
\name{correction_factor}
\alias{correction_factor}
\title{Border correction for NKDE}
\usage{
correction_factor(
  study_area,
  events,
  lines,
  method,
  bws,
  kernel_name,
  tol,
  digits,
  max_depth,
  sparse
)
}
\arguments{
\item{study_area}{A SpatialPolygonsDataFrame or a SpatialPolygons, the limit
of the study area.}

\item{events}{A SpatialPointsDataFrame representing the events on the
network.}

\item{lines}{The lines used to create the network}

\item{method}{The method to use when calculating the NKDE, must be one of
simple / discontinuous / continuous (see details for more information)}

\item{bws}{The kernel bandwidth (in meters) for each event}

\item{kernel_name}{The name of the kernel to use}

\item{tol}{When adding the events and the sampling points to the network, the
minimum distance between these points and the lines extremities. When
points are closer, they are added at the extremity of the lines.}

\item{digits}{The number of digits to keep in the spatial coordinates. It
ensures that topology is good when building the network. Default is 3}

\item{max_depth}{When using the continuous and discontinuous methods, the
calculation time and memory use can go wild  if the network has a lot of
small edges (area with a lot of intersections and a lot of events). To
avoid it, it is possible to set here a maximum depth. Considering that the
kernel is divided at intersections, a value of 8 should yield good
estimates. A larger value can be used without problem for the discontinuous
method. For the continuous method, a larger value will strongly impact
calculation speed.}

\item{sparse}{A boolean indicating if sparse or regular matrix should be
used by the Rcpp functions. Regular matrices are faster, but require more
memory and could lead to error, in particular with multiprocessing. Sparse
matrices are slower, but require much less memory.}
}
\value{
A numeric vector with the correction factor values for each event
}
\description{
Function to calculate the border correction factor.
}
\examples{
#no example provided, this is an internal function
}
\keyword{internal}
