% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_values.R
\name{generate_halton_random_single}
\alias{generate_halton_random_single}
\title{Generate Halton Value (Randomly Initialized)}
\usage{
generate_halton_random_single(i, dim, seed = 0)
}
\arguments{
\item{i}{The element of the sequence to extract.}

\item{dim}{The dimension of the sequence to extract.}

\item{seed}{Default `0`. The random seed.}
}
\value{
A single numeric value representing the `i`th element in the `dim` dimension.
}
\description{
Generate a single value from a seeded Halton set.

Note: This is much slower than generating the entire set ahead of time.
}
\examples{
#Generate a 3D sample:
point3d = c(generate_halton_random_single(10, dim = 1),
           generate_halton_random_single(10, dim = 2),
           generate_halton_random_single(10, dim = 3))
point3d

#Change the random seed:
#'#Generate a 3D sample
point3d_2 = c(generate_halton_random_single(10, dim = 1, seed = 10),
             generate_halton_random_single(10, dim = 2, seed = 10),
             generate_halton_random_single(10, dim = 3, seed = 10))
point3d_2
}
