% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizers.R
\name{summarize_corr2}
\alias{summarize_corr2}
\title{Pairwise correlation summarizer}
\usage{
summarize_corr2(ts_rdd, xcolumns, ycolumns, key_columns = list())
}
\arguments{
\item{ts_rdd}{Timeseries RDD being summarized}

\item{xcolumns}{A list of column names}

\item{ycolumns}{A list of column names disjoint from xcolumns}

\item{key_columns}{Optional list of columns that will form an equivalence
relation associating each row with the time series it belongs to (i.e., any
2 rows having equal values in those columns will be associated with the
same time series, and any 2 rows having differing values in those columns
are considered to be from 2 separate time series and will therefore be
summarized separately)
By default, `key_colums` is empty and all rows are considered to be part of
a single time series.}
}
\value{
A TimeSeriesRDD containing the summarized result
}
\description{
Compute pairwise correations for all possible pairs of columns such that the
first column of each pair is one of `xcolumns` and the second column of each
pair is one of `ycolumns`, storing results in new columns named with the
following pattern:
`<column1>_<column2>_correlation` and `<column1>_<column2>_correlationTStat`
for each pair of columns (column1, column2)
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")

if (!is.null(sc)) {
  sdf <- copy_to(
    sc,
    tibble::tibble(t = seq(10), x1 = rnorm(10), x2 = rnorm(10), y1 = rnorm(10), y2 = rnorm(10))
  )
  ts <- fromSDF(sdf, is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  ts_corr2 <- summarize_corr2(ts, xcolumns = c("x1", "x2"), ycolumns = c("y1", "y2"))
} else {
  message("Unable to establish a Spark connection!")
}

}
\seealso{
Other summarizers: 
\code{\link{summarize_avg}()},
\code{\link{summarize_corr}()},
\code{\link{summarize_count}()},
\code{\link{summarize_covar}()},
\code{\link{summarize_dot_product}()},
\code{\link{summarize_max}()},
\code{\link{summarize_min}()},
\code{\link{summarize_nth_central_moment}()},
\code{\link{summarize_nth_moment}()},
\code{\link{summarize_product}()},
\code{\link{summarize_quantile}()},
\code{\link{summarize_stddev}()},
\code{\link{summarize_sum}()},
\code{\link{summarize_var}()},
\code{\link{summarize_weighted_avg}()},
\code{\link{summarize_weighted_corr}()},
\code{\link{summarize_weighted_covar}()},
\code{\link{summarize_z_score}()}
}
\concept{summarizers}
