% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizers.R
\name{summarize_nth_moment}
\alias{summarize_nth_moment}
\title{N-th moment summarizer}
\usage{
summarize_nth_moment(ts_rdd, column, n, key_columns = list())
}
\arguments{
\item{ts_rdd}{Timeseries RDD being summarized}

\item{column}{Column to be summarized}

\item{n}{The order of moment to calculate}

\item{key_columns}{Optional list of columns that will form an equivalence
relation associating each row with the time series it belongs to (i.e., any
2 rows having equal values in those columns will be associated with the
same time series, and any 2 rows having differing values in those columns
are considered to be from 2 separate time series and will therefore be
summarized separately)
By default, `key_colums` is empty and all rows are considered to be part of
a single time series.}
}
\value{
A TimeSeriesRDD containing the summarized result
}
\description{
Compute n-th moment of the column specified and store result in a new column
named `<column>_<n>thMoment`
}
\examples{

library(sparklyr)
library(sparklyr.flint)

sc <- try_spark_connect(master = "local")

if (!is.null(sc)) {
  sdf <- copy_to(sc, tibble::tibble(t = seq(10), v = rnorm(10)))
  ts <- fromSDF(sdf, is_sorted = TRUE, time_unit = "SECONDS", time_column = "t")
  ts_4th_moment <- summarize_nth_moment(ts, column = "v", n = 4L)
} else {
  message("Unable to establish a Spark connection!")
}

}
\seealso{
Other summarizers: 
\code{\link{summarize_avg}()},
\code{\link{summarize_corr2}()},
\code{\link{summarize_corr}()},
\code{\link{summarize_count}()},
\code{\link{summarize_covar}()},
\code{\link{summarize_dot_product}()},
\code{\link{summarize_max}()},
\code{\link{summarize_min}()},
\code{\link{summarize_nth_central_moment}()},
\code{\link{summarize_product}()},
\code{\link{summarize_quantile}()},
\code{\link{summarize_stddev}()},
\code{\link{summarize_sum}()},
\code{\link{summarize_var}()},
\code{\link{summarize_weighted_avg}()},
\code{\link{summarize_weighted_corr}()},
\code{\link{summarize_weighted_covar}()},
\code{\link{summarize_z_score}()}
}
\concept{summarizers}
