% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aleatory_analysis.R
\name{aa_summariseReplicateRuns_overTime}
\alias{aa_summariseReplicateRuns_overTime}
\title{Calculate summary responses for consistency analysis simulations at multiple timepoints}
\usage{
aa_summariseReplicateRuns_overTime(FILEPATH, SAMPLESIZES, MEASURES,
  RESULTFILENAME, ALTFILENAME = NULL, OUTPUTFILECOLSTART,
  OUTPUTFILECOLEND, SUMMARYFILENAME, NUMSUBSETSPERSAMPLESIZE, TIMEPOINTS,
  TIMEPOINTSCALE)
}
\arguments{
\item{FILEPATH}{Directory where the results of the simulation runs, in folders or in single CSV file format, can be found}

\item{SAMPLESIZES}{The sample sizes chosen (i.e. in our case, this would be an array containing 1,5,50,100,300,800}

\item{MEASURES}{An array containing the names of the simulation output measures to be analysed.}

\item{RESULTFILENAME}{Name of the simulation results file. In the current version, XML and CSV files can be processed. If performing this analysis over multiple timepoints, it is assumed that the timepoint follows the file name, e.g. trackedCells_Close_12.csv.}

\item{ALTFILENAME}{In some cases, it may be relevant to read from a further results file if the initial file contains no results. This filename is set here. In the current version, XML and CSV files can be processed.}

\item{OUTPUTFILECOLSTART}{Column number in the simulation results file where output begins - saves (a) reading in unnecessary data, and (b) errors where the first column is a label, and therefore could contain duplicates.}

\item{OUTPUTFILECOLEND}{Column number in the simulation results file where the last output measure is.}

\item{SUMMARYFILENAME}{Name of the file generated that lists the maximum and median A-Test results for each sample size.}

\item{NUMSUBSETSPERSAMPLESIZE}{Number of subsets of simulation runs for each sample size. Defaults to 20}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing multiple simulation timepoints. If only analysing one timepoint, this should be set to NULL. If not, this should be an array of timepoints, e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing multiple simulation timepoints. Sets the scale of the timepoints being analysed, e.g. "Hours"}
}
\description{
Calculate summary responses for consistency analysis simulations at multiple timepoints
}
