% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_utilities.R
\name{generate_ensemble_training_set}
\alias{generate_ensemble_training_set}
\title{Internal function used to combine test set predictions from emulators to
form the ensemble training set}
\usage{
generate_ensemble_training_set(emulator, parameters, measures,
  observed_data, all_model_predictions)
}
\arguments{
\item{emulator}{An emulator object from which the test set data is being
predicted}

\item{parameters}{Vector containing the names of the simulation parameters
in the dataset on which the emulator is being trained}

\item{measures}{Vector containing the simulation outputs that the emulators
should be able to predict}

\item{observed_data}{Data obtained from experimentation on the simulator
itself, and now used to train the ensemble}

\item{all_model_predictions}{The set of predictions from numerous emulators
to which this set of predictions is being added}
}
\value{
updated all_model_predictions containing predictions for this
emulator. This updated list becomes the training set for the ensemble.
}
\description{
Internal function used to combine test set predictions from emulators to
form the ensemble training set
}
