% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_sampling.R
\name{oat_parameter_sampling}
\alias{oat_parameter_sampling}
\title{Create parameter samples for robustness (local) analysis}
\usage{
oat_parameter_sampling(FILEPATH, PARAMETERS, BASELINE, PMIN = NULL,
  PMAX = NULL, PINC = NULL, PARAMVALS = NULL, write_csv = TRUE,
  return_sample = FALSE)
}
\arguments{
\item{FILEPATH}{Directory where the parameter samples should be output to. For spartan-db this can be NULL}

\item{PARAMETERS}{Array containing the names of the parameters of which parameter samples will be generated}

\item{BASELINE}{Array containing the values assigned to each of these parameters in the calibrated baseline}

\item{PMIN}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space}

\item{PMAX}{Array containing the maximum value that should be used for each parameter.  Sets an upper bound on sampling space}

\item{PINC}{Array containing the increment value that should be applied for each parameter. For example, a parameter could have a minimum value of 10, and maximum value of 100, and be incremented by 10}

\item{PARAMVALS}{Array containing a list of strings for each parameter, each string containing comma separated values that should be assigned to that parameter. Thus sampling can be performed for specific values for each parameter, rather than a uniform incremented value. This replaces the PMIN, PMAX, and PINC where this method is used.}

\item{write_csv}{Whether the sample should be output to CSV file. Only used when using spartan with spartan-db package}

\item{return_sample}{Used by spartan database link package, to return parameter value samples generated. These can then be added to the database}
}
\description{
The robustness of a simulation to parameter alteration can be determined
through the use of this approach. Following the method described by Read
et al, the value of each parameter is adjusted independently, with the
remaining parameters staying unchanged from their calibrated value. This
method within the toolkit creates a set of simulation parameter sets to
enable such an analysis to be performed. One CSV file is created for each
parameter being examined (with the filename being
[Parameter Name]_Values.csv). Each CSV file will contain the parameters for
runs that need to be performed. For each set of parameters, the simulation
should be run for the number of times determined by Aleatory Analysis.
Once this has been completed, the results can be analysed
using the robustness analysis  methods included within this package
}
