% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.nb.inar1.r
\name{test.nb.inar1}
\alias{test.nb.inar1}
\title{Testing Hypotheses in NB-INAR(1) model}
\source{
\code{test.nb.inar1} uses code contributed by Thomas Asendorf.
}
\usage{
test.nb.inar1(dataC, dataE, h0 = 1)
}
\arguments{
\item{dataC}{a matrix or data frame containing count data from the control group. Columns correspond to time points, rows to observations.}

\item{dataE}{a matrix or data frame containing count data from the experiment group. Columns correspond to time points, rows to observations.}

\item{h0}{the value against which h is tested, see 'Details'.}
}
\value{
\code{test.nb.inar1} returns effect size, standard error, Z-statistic and p-value attained through standard normal approximation.
}
\description{
\code{test.nb.inar1} tests hypotheses for rate ratios of two groups in an NB-INAR(1) model
}
\details{
the function \code{test.nb.inar1} tests for the null hypothesis \eqn{\lambda_T/\lambda_C = h0} against the alternative \eqn{\lambda_T/\lambda_C \neq h_0}.
For attaining estimates, method of moments estimators are used.
}
\examples{
set.seed(8)
groupE<-rnbinom.inar1(n=1000, size=0.6, mu=2, rho=0.8, tp=6)
groupC<-rnbinom.inar1(n=1000, size=0.6, mu=2, rho=0.8, tp=6)

test.nb.inar1(dataC=groupC, dataE=groupE, h0=1)

}
\seealso{
\code{\link{rnbinom.inar1}} for information on the NB-INAR(1) model, \code{\link{n.nb.inar1}} for calculating
initial sample size required when performing inference, \code{\link{fit.nb.inar1}} for calculating
initial parameters required when performing sample size estimation
}
