% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/conf.interval.R
\name{conf.interval}
\alias{conf.interval}
\title{Confidence interval for mean or median}
\usage{
conf.interval(x, cl = 0.95, stat = "mean", std.error = TRUE)
}
\arguments{
\item{x}{Vector to calculate confidence interval for}

\item{cl}{Percent confidence level (default = 0.95)}

\item{stat}{Statistic (mean or median)}

\item{std.error}{Return standard error (TRUE/FALSE)}
}
\value{
lci          Lower confidence interval value

uci          Upper confidence interval value

mean         If stat = "mean", mean value of distribution

mean         Value of the mean or median

conf.level   Confidence level used for confidence interval

std.error    If std.error = TRUE standard error of distribution
}
\description{
Calculates confidence interval for the mean or median of a distribution with unknown population variance
}
\examples{
x <- runif(100)
 cr <- conf.interval(x, cl = 0.97)
 print(cr)

 d <- density(x)
 plot(d, type="n", main = "PDF with mean and 0.97 confidence interval")
   polygon(d, col="cyan3")
   abline(v=mean(x, na.rm = TRUE), lty = 2)
   segments( x0=cr[["lci"]], y0=mean(d$y), x1=cr[["uci"]],
             y1=mean(d$y), lwd = 2.5,
             col = "black")
 	legend("topright", legend = c("mean", "CI"),
 	       lty = c(2,1), lwd = c(1,2.5))
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}

