% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity.index.R
\name{proximity.index}
\alias{proximity.index}
\title{Proximity Index}
\usage{
proximity.index(x, y = NULL, min.dist = 0, max.dist = 1000,
  background = NULL)
}
\arguments{
\item{x}{A polygon class sp or sf object}

\item{y}{Optional column in data containing classes}

\item{min.dist}{Minimum threshold distance}

\item{max.dist}{Maximum neighbor distance}

\item{background}{Optional value in y column indicating background value}
}
\value{
A vector equal to nrow(x) of proximity index values, if a background value is specified
        NA values will be returned in the position(s) of the specified class
}
\description{
Calculates proximity index for a set of polygons
}
\examples{
library(sp)
library(rgeos)

# Create test polygons
data(meuse)
  coordinates(meuse) = ~x+y
  meuse_poly <- gBuffer(meuse, width = meuse$elev * 5, byid = TRUE)
    meuse_poly$LU <- sample(c("forest","nonforest"), nrow(meuse_poly), replace=TRUE) 

# All polygon proximity index 1000 radius	
( pidx <-proximity.index(meuse_poly, min.dist = 1) )
  pidx[pidx > 100] <- 100

# Class-level proximity index 1000 radius
( pidx.class <- proximity.index(meuse_poly, y = "LU", min.dist = 1) )
  pidx.class[pidx.class > 100] <- 100  
  
# plot index for all polygons
meuse_poly$pidx <- pidx
  spplot(meuse_poly, "pidx")

# plot index for class-level polygons 
meuse_poly$cpidx <- pidx.class
  spplot(meuse_poly, "cpidx")

# plot index for just forest class
forest <- meuse_poly[meuse_poly$LU == "forest",]
  spplot(forest, "cpidx")
  
}
\references{
Gustafson, E.J., & G.R. Parker (1994) Using an Index of Habitat Patch Proximity 
              for Landscape Design. Landscape and Urban Planning 29:117-130
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
